Attribute VB_Name = "modSwedll32"
'===============================================================
' Swiss Ephemeris API Declarations for Visual Basic 32-bit
' DLLFileName       :swedll32.dll
' DLLFileSize       :942,592 bytes
' DLLFileDateTime   :04/08/2021  14:04:22
' DLLFileType       :Dynamic link Library(32Bits)
' DLLFileVersion    :2.10.02
' --------------------------------------------------------------
' ThisFileName      :modSwedll32.bas
' Created on        :14.10.2021
' Created by        :D.Senthilathiban (Email:athi_ram@yahoo.com)
'===============================================================
'
' from posting by D.Senthilathiban (Email:athi_ram@yahoo.com) in
' Swiss Ephemeris mailing list
'
' This file is in the Public Domain last updated on 14-Oct-2021
'
' The swedll32.dll file must exist in the same directory as the VB executable,
' or in a system directory where it can be found at runtime
'
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' VB Interface for Handling NullChar-terminated C strings (Char *)/(Const Char *)
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' Some of the C functions takes arguments/Return NullChar-terminated C strings.
' These String variables are used for either to input the Name or to return the Name
' in the same argument variable.
'
' A) Where the arguments(String variables) expected to return Name are handled
'    in VB as follows.
'
' 1) String variables must be initialized with sufficient space as recommended
'    in the user's Manual. Usually of size minimum 256 Chars/bytes.
'    WARNING: Insufficient Size may return truncated String/Empty String or even
'             unexpected results in VB/VBA including up to VB/VBA Crash.
'
' 2) All such String variables must be passed in VB API function ByVal as String
'    (example: ByVal sName as String: sName is the name of the String variable)
'
' 3) It is possiable that the return String variables can have NullChar at the
'    end of actual name/Text to indicate the end of Text and the Trailing
'    spaces(if any) may remain same as per initialized values. So to get the
'    actual text in VB, the location of NullChar  must be found and the return
'    text must be trimmed just before NullChar. For this, TrimNullChar user
'    defined function is provided.
'
' B) Where functions expected to return Name are handled in VB as follows.

' 1) In VB, Sunch functions are declared to return Pointer to Array of Chars(String).
'    All such functions are declared with Keyword '_LPCHRA' at end of functionName.
'    Like functionName_LPCHRA for easy identification.
'
' 2) Call this function with necessary arguments and assign the return value(i.e.,
'    Pointer to Array of Chars) to a long datatype variable.
'
' 3) Pass this Pointer value in the user defined function GetStrFromLPCHARA will
'    get the actual Text returned by the C function. This function takes care of
'    finding the location of NullChar(to trim the text), allocation of required
'    String/Text size to hold and return the actual text.
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' VB Interface for Handling Pointer to DataTypes (double *)/(int32 *)/(int *)
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' Some of the C functions takes arguments Pointer to DataTypes as mentioned above.
' These variables are used to return the values in the same argument variable.
'
' C) Where the arguments expected to return array of Values are handled
'    in VB as follows.
'
' 1) variables must be initialized with sufficient space as recommended
'    in the user's Manual.
'    WARNING: Insufficient Size may return part of the values or even
'             unexpected results in VB/VBA including up to VB/VBA Crash.
'
' 2) First element of the Array variables must be passed in VB API function ByRef
'    (example: Dim dRet(20) as Double: initialized assuming default base 0
'              functionName(dRet(0),....) dRet(0) is First element of the Array)
'
' D) Where the arguments expected to return a Value are handled in VB as follows.
'
' 1) Define/Declare variables as required
'
' 2) Passe the variables in VB API function ByRef
'    (example: Dim dRet as Double: Define/Declare variable
'              functionName(dRet,....) dRet holds the return value)
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'    WARNING: This function is assumed for 32Bit Windows operating system with
'    32Bit VB Application/32Bit MSoffice VBA Program. Use of this function
'    (without necessary changes) in 64Bits Windows operating system platform or
'    '64Bit MSoffice VBA Program may return unexpected results in VB/VBA
'    including up to VB/VBA Crash.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'
' Wherever possible a brief description of the function with section number
' as per Programming interface to the Swiss Ephemeris Manual is given.
' For functions that are not having any section numbers as per Programming
' interface to the Swiss Ephemeris Manual may indicates that it is either
' obsolete or for Internal use/former users only.
' *********************CAUTION/WARNING:*************************************
' Such obsolete functions may work, but more understanding is required
' for purpose/return results before using it. Hence, it is highly advised
' to follow the recommendations given in Programming interface to the Swiss
' Ephemeris Manual.
'
' For more/updated details of functions/variables and Return values/Errors
' refer webpage https://www.astro.com/swisseph/swephprg.htm
' Programming interface to the Swiss Ephemeris Manual.
''**************************************************************************
'/*
'
'  License conditions
'  ------------------
'
'  This file is distributed with NO WARRANTY OF ANY KIND. No author/contributor
'  or distributor accepts any responsibility for the consequences of using it,
'  or for whether it serves any particular purpose or works at all.
'
'  The License grants you the right to use, copy, modify and redistribute,
'  but only under certain conditions that the File information, author/contributor
'  details and this notice be preserved on all copies.
'
'  The author/contributor have no control or influence over any of
'  the derived works, i.e. over software or services created by other
'  programmers which use Swiss Ephemeris functions.
'
'
'*/
'===================================================
'functions list for swedll32.dll
'===================================================
'1)_swe_azalt@40
'2)_swe_azalt_rev@24
'3)_swe_calc@24
'4)_swe_calc_pctr@28
'5)_swe_calc_ut@24
'6)_swe_close@0
'7)_swe_cotrans@16
'8)_swe_cotrans_sp@16
'9)_swe_cs2degstr@8
'10)_swe_cs2lonlatstr@16
'11)_swe_cs2timestr@16
'12)_swe_csnorm@4
'13)_swe_csroundsec@4
'14)_swe_d2l@8
'15)_swe_date_conversion@28
'16)_swe_day_of_week@8
'17)_swe_deg_midp@16
'18)_swe_degnorm@8
'19)_swe_deltat@8
'20)_swe_deltat_ex@16
'21)_swe_difcs2n@8
'22)_swe_difcsn@8
'23)_swe_difdeg2n@16
'24)_swe_difdegn@16
'25)_swe_difrad2n@16
'26)_swe_fixstar2@24
'27)_swe_fixstar2_mag@12
'28)_swe_fixstar2_ut@24
'29)_swe_fixstar@24
'30)_swe_fixstar_mag@12
'31)_swe_fixstar_ut@24
'32)_swe_gauquelin_sector@52
'33)_swe_get_astro_models@12
'34)_swe_get_ayanamsa@8
'35)_swe_get_ayanamsa_ex@20
'36)_swe_get_ayanamsa_ex_ut@20
'37)_swe_get_ayanamsa_name@4
'38)_swe_get_ayanamsa_ut@8
'39)_swe_get_current_file_data@16
'40)_swe_get_library_path@4
'41)_swe_get_orbital_elements@24
'42)_swe_get_planet_name@8
'43)_swe_get_tid_acc@0
'44)_swe_heliacal_angle@72
'45)_swe_heliacal_pheno_ut@40
'46)_swe_heliacal_ut@40
'47)_swe_helio_cross@36
'48)_swe_helio_cross_ut@36
'49)_swe_house_name@4
'50)_swe_house_pos@36
'51)_swe_houses@36
'52)_swe_houses_armc@36
'53)_swe_houses_armc_ex2@48
'54)_swe_houses_ex2@52
'55)_swe_houses_ex@40
'56)_swe_jdet_to_utc@36
'57)_swe_jdut1_to_utc@36
'58)_swe_julday@24
'59)_swe_lat_to_lmt@24
'60)_swe_lmt_to_lat@24
'61)_swe_lun_eclipse_how@24
'62)_swe_lun_eclipse_when@28
'63)_swe_lun_eclipse_when_loc@32
'64)_swe_lun_occult_when_glob@36
'65)_swe_lun_occult_when_loc@40
'66)_swe_lun_occult_where@32
'67)_swe_mooncross@24
'68)_swe_mooncross_node@24
'69)_swe_mooncross_node_ut@24
'70)_swe_mooncross_ut@24
'71)_swe_nod_aps@40
'72)_swe_nod_aps_ut@40
'73)_swe_orbit_max_min_true_distance@32
'74)_swe_pheno@24
'75)_swe_pheno_ut@24
'76)_swe_rad_midp@16
'77)_swe_radnorm@8
'78)_swe_refrac@28
'79)_swe_refrac_extended@48
'80)_swe_revjul@28
'81)_swe_rise_trans@52
'82)_swe_rise_trans_true_hor@60
'83)_swe_set_astro_models@8
'84)_swe_set_delta_t_userdef@8
'85)_swe_set_ephe_path@4
'86)_swe_set_interpolate_nut@4
'87)_swe_set_jpl_file@4
'88)_swe_set_lapse_rate@8
'89)_swe_set_sid_mode@20
'90)_swe_set_tid_acc@8
'91)_swe_set_topo@24
'92)_swe_sidtime0@24
'93)_swe_sidtime@8
'94)_swe_sol_eclipse_how@24
'95)_swe_sol_eclipse_when_glob@28
'96)_swe_sol_eclipse_when_loc@32
'97)_swe_sol_eclipse_where@24
'98)_swe_solcross@24
'99)_swe_solcross_ut@24
'100)_swe_split_deg@32
'101)_swe_time_equ@16
'102)_swe_topo_arcus_visionis@80
'103)_swe_utc_time_zone@60
'104)_swe_utc_to_jd@40
'105)_swe_version@4
'106)_swe_vis_limit_mag@36
'===================================================

'################################################################################
'Exports Procedures from various Source Files:*.C
'################################################################################
'================================================================================
'FileRef  : {C1}
'FileName : swecl.c
'FileDate : 04/08/2021 17:11:51
'FileSize : 233442 Bytes
'--------------------------------------------------------------------------------
'{C1}{ P1}Line[  565]:     int32 CALL_CONV swe_sol_eclipse_where(
'{C1}{ P1}Line[  566]:          double tjd_ut,
'{C1}{ P1}Line[  567]:                     int32 ifl,
'{C1}{ P1}Line[  568]:          double *geopos,
'{C1}{ P1}Line[  569]:          double *attr,
'{C1}{ P1}Line[  570]:          char *serr)
'{C1}{ P2}Line[  606]:     int32 CALL_CONV swe_lun_occult_where(
'{C1}{ P2}Line[  607]:          double tjd_ut,
'{C1}{ P2}Line[  608]:                     int32 ipl,
'{C1}{ P2}Line[  609]:                     char *starname,
'{C1}{ P2}Line[  610]:                     int32 ifl,
'{C1}{ P2}Line[  611]:          double *geopos,
'{C1}{ P2}Line[  612]:          double *attr,
'{C1}{ P2}Line[  613]:          char *serr)
'{C1}{ P3}Line[  922]:     int32 CALL_CONV swe_sol_eclipse_how(
'{C1}{ P3}Line[  923]:               double tjd_ut,
'{C1}{ P3}Line[  924]:               int32 ifl,
'{C1}{ P3}Line[  925]:               double *geopos,
'{C1}{ P3}Line[  926]:               double *attr,
'{C1}{ P3}Line[  927]:               char *serr)
'{C1}{ P4}Line[ 1185]:     int32 CALL_CONV swe_sol_eclipse_when_glob(double tjd_start, int32 ifl, int32 ifltype,
'{C1}{ P4}Line[ 1186]:          double *tret, int32 backward, char *serr)
'{C1}{ P5}Line[ 1572]:     int32 CALL_CONV swe_lun_occult_when_glob(
'{C1}{ P5}Line[ 1573]:          double tjd_start, int32 ipl, char *starname, int32 ifl, int32 ifltype,
'{C1}{ P5}Line[ 1574]:          double *tret, int32 backward, char *serr)
'{C1}{ P6}Line[ 2019]:     int32 CALL_CONV swe_sol_eclipse_when_loc(double tjd_start, int32 ifl,
'{C1}{ P6}Line[ 2020]:          double *geopos, double *tret, double *attr, int32 backward, char *serr)
'{C1}{ P7}Line[ 2071]:     int32 CALL_CONV swe_lun_occult_when_loc(double tjd_start, int32 ipl, char *starname, int32 ifl,
'{C1}{ P7}Line[ 2072]:          double *geopos, double *tret, double *attr, int32 backward, char *serr)
'{C1}{ P8}Line[ 2790]:     void CALL_CONV swe_azalt(
'{C1}{ P8}Line[ 2791]:           double tjd_ut,
'{C1}{ P8}Line[ 2792]:           int32  calc_flag,
'{C1}{ P8}Line[ 2793]:           double *geopos,
'{C1}{ P8}Line[ 2794]:           double atpress,
'{C1}{ P8}Line[ 2795]:           double attemp,
'{C1}{ P8}Line[ 2796]:           double *xin,
'{C1}{ P8}Line[ 2797]:           double *xaz)
'{C1}{ P9}Line[ 2841]:     void CALL_CONV swe_azalt_rev(
'{C1}{ P9}Line[ 2842]:           double tjd_ut,
'{C1}{ P9}Line[ 2843]:           int32  calc_flag,
'{C1}{ P9}Line[ 2844]:           double *geopos,
'{C1}{ P9}Line[ 2845]:           double *xin,
'{C1}{ P9}Line[ 2846]:           double *xout)
'{C1}{P10}Line[ 2889]:     double CALL_CONV swe_refrac(double inalt, double atpress, double attemp, int32 calc_flag)
'{C1}{P11}Line[ 2988]:     void CALL_CONV swe_set_lapse_rate(double lapse_rate)
'{C1}{P12}Line[ 3037]:     double CALL_CONV swe_refrac_extended(double inalt, double geoalt, double atpress, double attemp, double lapse_rate, int32 calc_flag, double *dret)
'{C1}{P13}Line[ 3192]:     int32 CALL_CONV swe_lun_eclipse_how(
'{C1}{P13}Line[ 3193]:               double tjd_ut,
'{C1}{P13}Line[ 3194]:               int32 ifl,
'{C1}{P13}Line[ 3195]:               double *geopos,
'{C1}{P13}Line[ 3196]:               double *attr,
'{C1}{P13}Line[ 3197]:               char *serr)
'{C1}{P14}Line[ 3380]:     int32 CALL_CONV swe_lun_eclipse_when(double tjd_start, int32 ifl, int32 ifltype,
'{C1}{P14}Line[ 3381]:          double *tret, int32 backward, char *serr)
'{C1}{P15}Line[ 3635]:     int32 CALL_CONV swe_lun_eclipse_when_loc(double tjd_start, int32 ifl,
'{C1}{P15}Line[ 3636]:          double *geopos, double *tret, double *attr, int32 backward, char *serr)
'{C1}{P16}Line[ 3793]:     int32 CALL_CONV swe_pheno(double tjd, int32 ipl, int32 iflag, double *attr, char *serr)
'{C1}{P17}Line[ 4131]:     int32 CALL_CONV swe_pheno_ut(double tjd_ut, int32 ipl, int32 iflag, double *attr, char *serr)
'{C1}{P18}Line[ 4371]:     int32 CALL_CONV swe_rise_trans(
'{C1}{P18}Line[ 4372]:                    double tjd_ut, int32 ipl, char *starname,
'{C1}{P18}Line[ 4373]:             int32 epheflag, int32 rsmi,
'{C1}{P18}Line[ 4374]:                    double *geopos,
'{C1}{P18}Line[ 4375]:             double atpress, double attemp,
'{C1}{P18}Line[ 4376]:                    double *tret,
'{C1}{P18}Line[ 4377]:                    char *serr)
'{C1}{P19}Line[ 4403]:     int32 CALL_CONV swe_rise_trans_true_hor(
'{C1}{P19}Line[ 4404]:                    double tjd_ut, int32 ipl, char *starname,
'{C1}{P19}Line[ 4405]:             int32 epheflag, int32 rsmi,
'{C1}{P19}Line[ 4406]:                    double *geopos,
'{C1}{P19}Line[ 4407]:             double atpress, double attemp,
'{C1}{P19}Line[ 4408]:             double horhgt,
'{C1}{P19}Line[ 4409]:                    double *tret,
'{C1}{P19}Line[ 4410]:                    char *serr)
'{C1}{P20}Line[ 5079]:     int32 CALL_CONV swe_nod_aps(double tjd_et, int32 ipl, int32 iflag,
'{C1}{P20}Line[ 5080]:                           int32  method,
'{C1}{P20}Line[ 5081]:                           double *xnasc, double *xndsc,
'{C1}{P20}Line[ 5082]:                           double *xperi, double *xaphe,
'{C1}{P20}Line[ 5083]:                           char *serr)
'{C1}{P21}Line[ 5660]:     int32 CALL_CONV swe_nod_aps_ut(double tjd_ut, int32 ipl, int32 iflag,
'{C1}{P21}Line[ 5661]:                           int32  method,
'{C1}{P21}Line[ 5662]:                           double *xnasc, double *xndsc,
'{C1}{P21}Line[ 5663]:                           double *xperi, double *xaphe,
'{C1}{P21}Line[ 5664]:                           char *serr) {
'{C1}{P22}Line[ 5787]:     int32 CALL_CONV swe_get_orbital_elements(
'{C1}{P22}Line[ 5788]:       double tjd_et,
'{C1}{P22}Line[ 5789]:       int32 ipl, int32 iflag,
'{C1}{P22}Line[ 5790]:       double *dret,
'{C1}{P22}Line[ 5791]:       char *serr)
'{C1}{P23}Line[ 6175]:     int32 CALL_CONV swe_orbit_max_min_true_distance(double tjd_et, int32 ipl, int32 iflag, double *dmax, double *dmin, double *dtrue, char *serr)
'{C1}{P24}Line[ 6314]:     int32 CALL_CONV swe_gauquelin_sector(
'{C1}{P24}Line[ 6315]:       double t_ut,  /* input time (UT) */
'{C1}{P24}Line[ 6316]:       int32 ipl,    /* planet number, if planet, or moon;
'{C1}{P24}Line[ 6317]:                      * ipl is ignored if the following parameter (starname) is set*/
'{C1}{P24}Line[ 6318]:       char *starname, /* star name, if star; otherwise NULL or empty */
'{C1}{P24}Line[ 6319]:       int32 iflag,  /* flag for ephemeris and SEFLG_TOPOCTR */
'{C1}{P24}Line[ 6320]:       int32 imeth,  /* method: 0 = with lat., 1 = without lat.,
'{C1}{P24}Line[ 6321]:           *         2 = from rise/set, 3 = from rise/set with refraction */
'{C1}{P24}Line[ 6322]:       double *geopos, /* array of three doubles containing
'{C1}{P24}Line[ 6323]:             * geograph. long., lat., height of observer */
'{C1}{P24}Line[ 6324]:       double atpress, /* atmospheric pressure, only useful with imeth=3;
'{C1}{P24}Line[ 6325]:             * if 0, default = 1013.25 mbar is used */
'{C1}{P24}Line[ 6326]:       double attemp,  /* atmospheric temperature in degrees Celsius,
'{C1}{P24}Line[ 6327]:                        *only useful with imeth=3 */
'{C1}{P24}Line[ 6328]:       double *dgsect, /* return address for gauquelin sector position */
'{C1}{P24}Line[ 6329]:       char *serr)     /* return address for error message */
'--------------------------------------------------------------------------------
'{C1}Total Exports Procedures: 24
'================================================================================
'FileRef  : {C2}
'FileName : swedate.c
'FileDate : 02/05/2021 17:30:36
'FileSize : 20651 Bytes
'--------------------------------------------------------------------------------
'{C2}{ P1}Line[   90]:     int CALL_CONV swe_date_conversion(int y,
'{C2}{ P1}Line[   91]:               int m,
'{C2}{ P1}Line[   92]:               int d,     /* day, month, year */
'{C2}{ P1}Line[   93]:               double uttime,     /* UT in hours (decimal) */
'{C2}{ P1}Line[   94]:               char c,        /* calendar g[regorian]|j[ulian] */
'{C2}{ P1}Line[   95]:               double *tjd)
'{C2}{ P2}Line[  159]:     double CALL_CONV swe_julday(int year, int month, int day, double hour, int gregflag)
'{C2}{ P3}Line[  200]:     void CALL_CONV swe_revjul (double jd, int gregflag,
'{C2}{ P3}Line[  201]:           int *jyear, int *jmon, int *jday, double *jut)
'{C2}{ P4}Line[  234]:     void CALL_CONV swe_utc_time_zone(
'{C2}{ P4}Line[  235]:             int32 iyear, int32 imonth, int32 iday,
'{C2}{ P4}Line[  236]:             int32 ihour, int32 imin, double dsec,
'{C2}{ P4}Line[  237]:             double d_timezone,
'{C2}{ P4}Line[  238]:             int32 *iyear_out, int32 *imonth_out, int32 *iday_out,
'{C2}{ P4}Line[  239]:             int32 *ihour_out, int32 *imin_out, double *dsec_out
'{C2}{ P4}Line[  240]:             )
'{C2}{ P5}Line[  375]:     int32 CALL_CONV swe_utc_to_jd(int32 iyear, int32 imonth, int32 iday, int32 ihour, int32 imin, double dsec, int32 gregflag, double *dret, char *serr)
'{C2}{ P6}Line[  486]:     void CALL_CONV swe_jdet_to_utc(double tjd_et, int32 gregflag, int32 *iyear, int32 *imonth, int32 *iday, int32 *ihour, int32 *imin, double *dsec)
'{C2}{ P7}Line[  583]:     void CALL_CONV swe_jdut1_to_utc(double tjd_ut, int32 gregflag, int32 *iyear, int32 *imonth, int32 *iday, int32 *ihour, int32 *imin, double *dsec)
'--------------------------------------------------------------------------------
'{C2}Total Exports Procedures: 7
'================================================================================
'FileRef  : {C3}
'FileName : swehel.c
'FileDate : 04/08/2021 17:11:51
'FileSize : 126786 Bytes
'--------------------------------------------------------------------------------
'{C3}{ P1}Line[ 1464]:     int32 CALL_CONV swe_vis_limit_mag(double tjdut, double *dgeo, double *datm, double *dobs, char *ObjectName, int32 helflag, double *dret, char *serr)
'{C3}{ P2}Line[ 1601]:     int32 CALL_CONV swe_topo_arcus_visionis(double tjdut, double *dgeo, double *datm, double *dobs, int32 helflag, double mag, double azi_obj, double alt_obj, double azi_sun, double azi_moon, double alt_moon, double *dret, char *serr)
'{C3}{ P3}Line[ 1695]:     int32 CALL_CONV swe_heliacal_angle(double tjdut, double *dgeo, double *datm, double *dobs, int32 helflag, double mag, double azi_obj, double azi_sun, double azi_moon, double alt_moon, double *dret, char *serr)
'{C3}{ P4}Line[ 1862]:     int32 CALL_CONV swe_heliacal_pheno_ut(double JDNDaysUT, double *dgeo, double *datm, double *dobs, char *ObjectNameIn, int32 TypeEvent, int32 helflag, double *darr, char *serr)
'{C3}{ P5}Line[ 3393]:     int32 CALL_CONV swe_heliacal_ut(double JDNDaysUTStart, double *dgeo, double *datm, double *dobs, char *ObjectNameIn, int32 TypeEvent, int32 helflag, double *dret, char *serr_ret)
'--------------------------------------------------------------------------------
'{C3}Total Exports Procedures: 5
'================================================================================
'FileRef  : {C4}
'FileName : swehouse.c
'FileDate : 04/08/2021 17:11:51
'FileSize : 115124 Bytes
'--------------------------------------------------------------------------------
'{C4}{ P1}Line[  130]:     int CALL_CONV swe_houses(double tjd_ut,
'{C4}{ P1}Line[  131]:                  double geolat,
'{C4}{ P1}Line[  132]:                  double geolon,
'{C4}{ P1}Line[  133]:                  int hsys,
'{C4}{ P1}Line[  134]:                  double *cusp,
'{C4}{ P1}Line[  135]:                  double *ascmc)
'{C4}{ P2}Line[  178]:     int CALL_CONV swe_houses_ex(double tjd_ut,
'{C4}{ P2}Line[  179]:                                     int32 iflag,
'{C4}{ P2}Line[  180]:                  double geolat,
'{C4}{ P2}Line[  181]:                  double geolon,
'{C4}{ P2}Line[  182]:                  int hsys,
'{C4}{ P2}Line[  183]:                  double *cusp,
'{C4}{ P2}Line[  184]:                  double *ascmc)
'{C4}{ P3}Line[  207]:     int CALL_CONV swe_houses_ex2(double tjd_ut,
'{C4}{ P3}Line[  208]:                                     int32 iflag,
'{C4}{ P3}Line[  209]:                  double geolat,
'{C4}{ P3}Line[  210]:                  double geolon,
'{C4}{ P3}Line[  211]:                  int hsys,
'{C4}{ P3}Line[  212]:                  double *cusp,
'{C4}{ P3}Line[  213]:                  double *ascmc,
'{C4}{ P3}Line[  214]:                      double *cusp_speed,
'{C4}{ P3}Line[  215]:                  double *ascmc_speed,
'{C4}{ P3}Line[  216]:                  char *serr)
'{C4}{ P4}Line[  590]:     int CALL_CONV swe_houses_armc(
'{C4}{ P4}Line[  591]:                  double armc,
'{C4}{ P4}Line[  592]:                  double geolat,
'{C4}{ P4}Line[  593]:                  double eps,
'{C4}{ P4}Line[  594]:                  int hsys,
'{C4}{ P4}Line[  595]:                  double *cusp,
'{C4}{ P4}Line[  596]:                  double *ascmc)
'{C4}{ P5}Line[  622]:     int CALL_CONV swe_houses_armc_ex2(
'{C4}{ P5}Line[  623]:                  double armc,
'{C4}{ P5}Line[  624]:                  double geolat,
'{C4}{ P5}Line[  625]:                  double eps,
'{C4}{ P5}Line[  626]:                  int hsys,
'{C4}{ P5}Line[  627]:                  double *cusp,
'{C4}{ P5}Line[  628]:                  double *ascmc,
'{C4}{ P5}Line[  629]:                  double *cusp_speed,
'{C4}{ P5}Line[  630]:                  double *ascmc_speed,
'{C4}{ P5}Line[  631]:                  char *serr)
'{C4}{ P6}Line[  823]:     char *CALL_CONV swe_house_name(int hsys)
'{C4}{ P7}Line[ 2209]:     double CALL_CONV swe_house_pos(
'{C4}{ P7}Line[ 2210]:      double armc, double geolat, double eps, int hsys, double *xpin, char *serr)
'--------------------------------------------------------------------------------
'{C4}Total Exports Procedures: 7
'================================================================================
'FileRef  : {C5}
'FileName : swejpl.c
'FileDate : 02/05/2021 17:30:36
'FileSize : 34432 Bytes
'--------------------------------------------------------------------------------
'{C5}Total Exports Procedures: 0
'================================================================================
'FileRef  : {C6}
'FileName : swemmoon.c
'FileDate : 02/05/2021 17:30:36
'FileSize : 63318 Bytes
'--------------------------------------------------------------------------------
'{C6}Total Exports Procedures: 0
'================================================================================
'FileRef  : {C7}
'FileName : swemplan.c
'FileDate : 02/05/2021 17:30:36
'FileSize : 28847 Bytes
'--------------------------------------------------------------------------------
'{C7}Total Exports Procedures: 0
'================================================================================
'FileRef  : {C8}
'FileName : sweph.c
'FileDate : 04/08/2021 17:11:51
'FileSize : 302292 Bytes
'--------------------------------------------------------------------------------
'{C8}{ P1}Line[  239]:     char *CALL_CONV swe_version(char *s)
'{C8}{ P2}Line[  261]:     char *CALL_CONV swe_get_library_path(char *s)
'{C8}{ P3}Line[  314]:     int32 CALL_CONV swe_calc(double tjd, int ipl, int32 iflag,
'{C8}{ P3}Line[  315]:      double *xx, char *serr)
'{C8}{ P4}Line[  568]:     int32 CALL_CONV swe_calc_ut(double tjd_ut, int32 ipl, int32 iflag,
'{C8}{ P4}Line[  569]:      double *xx, char *serr)
'{C8}{ P5}Line[ 1276]:     void CALL_CONV swe_close(void)
'{C8}{ P6}Line[ 1358]:     void CALL_CONV swe_set_ephe_path(char *path)
'{C8}{ P7}Line[ 1525]:     void CALL_CONV swe_set_jpl_file(char *fname)
'{C8}{ P8}Line[ 2931]:     void CALL_CONV swe_set_sid_mode(int32 sid_mode, double t0, double ayan_t0)
'{C8}{ P9}Line[ 2999]:     int32 CALL_CONV swe_get_ayanamsa_ex(double tjd_et, int32 iflag, double *daya, char *serr)
'{C8}{P10}Line[ 3293]:     int32 CALL_CONV swe_get_ayanamsa_ex_ut(double tjd_ut, int32 iflag, double *daya, char *serr)
'{C8}{P11}Line[ 3318]:     double CALL_CONV swe_get_ayanamsa(double tjd_et)
'{C8}{P12}Line[ 3327]:     double CALL_CONV swe_get_ayanamsa_ut(double tjd_ut)
'{C8}{P13}Line[ 6911]:     int32 CALL_CONV swe_fixstar2(char *star, double tjd, int32 iflag,
'{C8}{P13}Line[ 6912]:       double *xx, char *serr)
'{C8}{P14}Line[ 6977]:     int32 CALL_CONV swe_fixstar2_ut(char *star, double tjd_ut, int32 iflag,
'{C8}{P14}Line[ 6978]:       double *xx, char *serr)
'{C8}{P15}Line[ 7010]:     int32 CALL_CONV swe_fixstar2_mag(char *star, double *mag, char *serr)
'{C8}{P16}Line[ 7045]:     char *CALL_CONV swe_get_planet_name(int ipl, char *s)
'{C8}{P17}Line[ 7225]:     const char *CALL_CONV swe_get_ayanamsa_name(int32 isidmode)
'{C8}{P18}Line[ 7347]:     void CALL_CONV swe_set_topo(double geolon, double geolat, double geoalt)
'{C8}{P19}Line[ 7485]:     int32 CALL_CONV swe_time_equ(double tjd_ut, double *E, char *serr)
'{C8}{P20}Line[ 7513]:     int32 CALL_CONV swe_lmt_to_lat(double tjd_lmt, double geolon, double *tjd_lat, char *serr)
'{C8}{P21}Line[ 7523]:     int32 CALL_CONV swe_lat_to_lmt(double tjd_lat, double geolon, double *tjd_lmt, char *serr)
'{C8}{P22}Line[ 7990]:     int32 CALL_CONV swe_fixstar(char *star, double tjd, int32 iflag,
'{C8}{P22}Line[ 7991]:       double *xx, char *serr)
'{C8}{P23}Line[ 8051]:     int32 CALL_CONV swe_fixstar_ut(char *star, double tjd_ut, int32 iflag,
'{C8}{P23}Line[ 8052]:       double *xx, char *serr)
'{C8}{P24}Line[ 8084]:     int32 CALL_CONV swe_fixstar_mag(char *star, double *mag, char *serr)
'{C8}{P25}Line[ 8136]:     int32 CALL_CONV swe_calc_pctr(double tjd, int32 ipl, int32 iplctr, int32 iflag, double *xxret, char *serr)
'{C8}{P26}Line[ 8391]:     const char *CALL_CONV swe_get_current_file_data(int ifno, double *tfstart, double *tfend, int *denum)
'{C8}{P27}Line[ 8415]:     double CALL_CONV swe_solcross(double x2cross, double jd_et, int flag, char *serr)
'{C8}{P28}Line[ 8449]:     double CALL_CONV swe_solcross_ut(double x2cross, double jd_ut, int flag, char *serr)
'{C8}{P29}Line[ 8483]:     double CALL_CONV swe_mooncross(double x2cross, double jd_et, int flag, char *serr)
'{C8}{P30}Line[ 8519]:     double CALL_CONV swe_mooncross_ut(double x2cross, double jd_ut, int flag, char *serr)
'{C8}{P31}Line[ 8550]:     double CALL_CONV swe_mooncross_node(double jd_et, int flag, double *xlon, double *xla, char *serr)
'{C8}{P32}Line[ 8587]:     double CALL_CONV swe_mooncross_node_ut(double jd_ut, int flag, double *xlon, double *xla, char *serr)
'{C8}{P33}Line[ 8627]:     int32 CALL_CONV swe_helio_cross(int ipl, double x2cross, double jd_et, int iflag, int dir, double *jd_cross, char *serr)
'{C8}{P34}Line[ 8673]:     int32 CALL_CONV swe_helio_cross_ut(int ipl, double x2cross, double jd_ut, int iflag, int dir, double *jd_cross, char *serr)
'--------------------------------------------------------------------------------
'{C8}Total Exports Procedures: 34
'================================================================================
'FileRef  : {C9}
'FileName : swephlib.c
'FileDate : 04/08/2021 17:11:51
'FileSize : 169000 Bytes
'--------------------------------------------------------------------------------
'{C9}{ P1}Line[  106]:     double CALL_CONV swe_degnorm(double x)
'{C9}{ P2}Line[  117]:     double CALL_CONV swe_radnorm(double x)
'{C9}{ P3}Line[  126]:     double CALL_CONV swe_deg_midp(double x1, double x0)
'{C9}{ P4}Line[  134]:     double CALL_CONV swe_rad_midp(double x1, double x0)
'{C9}{ P5}Line[  223]:     void CALL_CONV swe_cotrans(double *xpo, double *xpn, double eps)
'{C9}{ P6}Line[  251]:     void CALL_CONV swe_cotrans_sp(double *xpo, double *xpn, double eps)
'{C9}{ P7}Line[ 2701]:     double CALL_CONV swe_deltat_ex(double tjd, int32 iflag, char *serr)
'{C9}{ P8}Line[ 2712]:     double CALL_CONV swe_deltat(double tjd)
'{C9}{ P9}Line[ 3154]:     double CALL_CONV swe_get_tid_acc()
'{C9}{P10}Line[ 3165]:     void CALL_CONV swe_set_tid_acc(double t_acc)
'{C9}{P11}Line[ 3176]:     void CALL_CONV swe_set_delta_t_userdef(double dt)
'{C9}{P12}Line[ 3464]:     double CALL_CONV swe_sidtime0(double tjd, double eps, double nut)
'{C9}{P13}Line[ 3558]:     void CALL_CONV swe_set_interpolate_nut(AS_BOOL do_interpolate)
'{C9}{P14}Line[ 3580]:     double CALL_CONV swe_sidtime(double tjd_ut)
'{C9}{P15}Line[ 3790]:     centisec CALL_CONV swe_csnorm(centisec p)
'{C9}{P16}Line[ 3803]:     centisec CALL_CONV swe_difcsn (centisec p1, centisec p2)
'{C9}{P17}Line[ 3808]:     double CALL_CONV swe_difdegn (double p1, double p2)
'{C9}{P18}Line[ 3817]:     centisec CALL_CONV swe_difcs2n(centisec p1, centisec p2)
'{C9}{P19}Line[ 3824]:     double CALL_CONV swe_difdeg2n(double p1, double p2)
'{C9}{P20}Line[ 3831]:     double CALL_CONV swe_difrad2n(double p1, double p2)
'{C9}{P21}Line[ 3841]:     centisec CALL_CONV swe_csroundsec(centisec x)
'{C9}{P22}Line[ 3853]:     int32 CALL_CONV swe_d2l(double x)
'{C9}{P23}Line[ 3864]:     int CALL_CONV swe_day_of_week(double jd)
'{C9}{P24}Line[ 3869]:     char *CALL_CONV swe_cs2timestr(CSEC t, int sep, AS_BOOL suppressZero, char *a)
'{C9}{P25}Line[ 3893]:     char *CALL_CONV swe_cs2lonlatstr(CSEC t, char pchar, char mchar, char *sp)
'{C9}{P26}Line[ 3923]:     char *CALL_CONV swe_cs2degstr(CSEC t, char *a)
'{C9}{P27}Line[ 4016]:     void CALL_CONV swe_split_deg(double ddeg, int32 roundflag, int32 *ideg, int32 *imin, int32 *isec, double *dsecfr, int32 *isgn)
'{C9}{P28}Line[ 4184]:     void CALL_CONV swe_set_astro_models(char *samod, int32 iflag)
'{C9}{P29}Line[ 4401]:     void CALL_CONV swe_get_astro_models(char *samod, char *sdet, int32 iflag)
'--------------------------------------------------------------------------------
'{C9}Total Exports Procedures: 29
'================================================================================
'FileRef  : {C10}
'FileName : swetest.c
'FileDate : 04/08/2021 17:11:51
'FileSize : 147304 Bytes
'--------------------------------------------------------------------------------
'{C10}Total Exports Procedures: 0
'================================================================================
'Total Exports Procedures: 106
'================================================================================
'################################################################################
'End of Exports Procedures from various Source Files:*.C
'The above Exports C Procedures/functions prototype are kept in this file for
'detailed reference to develop/verify Visual Basic API function declerations
'such as function names, variables, datatypes and return values only.
'################################################################################


'################################################################################
'Exports VB API32 Declarations from Header File:swephexp.h
'################################################################################
'FileRef  : {H1}
'FileName : swephexp.h
'FileDate : 04/08/2021 17:11:51
'FileSize : 41939 Bytes
'--------------------------------------------------------------------------------
'[1]_swe_azalt@40{swe_azalt}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  898]:     ext_def(void) swe_azalt(double tjd_ut,int32 calc_flag,double *geopos,double atpress,double attemp,double *xin,double *xaz);
'8.14.      swe_azalt(), horizontal coordinates, azimuth, altitude
'computes the horizontal coordinates (azimuth and altitude) of a planet or
'a star from either ecliptical or equatorial coordinates.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_azalt Lib "swedll32.dll" _
                    Alias "_swe_azalt@40" ( _
                      ByVal tjd_ut As Double, _
                      ByVal calc_flag As Long, _
                      ByRef geopos As Double, _
                      ByVal atpress As Double, _
                      ByVal attemp As Double, _
                      ByRef xin As Double, _
                      ByRef xaz As Double _
                    ) 'No return
                    'tjd_ut         =//Julian day, universal time (UT)
                    'calc_flag      =/* Flag for Calculation, SE_ECL2HOR or SE_EQU2HOR. See user's manual.*/
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'atpress        =/* atmospheric pressure in mbar/hPa */
                    'attemp         =// atmospheric temperature in degrees Celsius
                    'xin            =/* array of 3 doubles: position of body in either ecliptical or equatorial coordinates, depending on calc_flag
                    'xaz            =// return array of 3 doubles, containing azimuth, true altitude, apparent altitude
                    '<RETURN>: Nil


'[2]_swe_azalt_rev@24{swe_azalt_rev}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  907]:     ext_def(void) swe_azalt_rev(double tjd_ut,int32 calc_flag,double *geopos,double *xin,double *xout);
'8.15.      swe_azalt_rev()
'The function swe_azalt_rev() is not precisely the reverse of swe_azalt().
'It computes either ecliptical or equatorial coordinates from azimuth and true altitude.
'If only an apparent altitude is given, the true altitude has to be computed first with
'the function swe_refrac().
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_azalt_rev Lib "swedll32.dll" _
                    Alias "_swe_azalt_rev@24" ( _
                      ByVal tjd_ut As Double, _
                      ByVal calc_flag As Long, _
                      ByRef geopos As Double, _
                      ByRef xin As Double, _
                      ByRef xout As Double _
                    ) 'No return
                    'tjd_ut         =//Julian day, universal time (UT)
                    'calc_flag      =/* Flag for Calculation. See user's manual */
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'xin            =/* array of 3 doubles: position of body in either ecliptical or equatorial coordinates, depending on calc_flag
                    'xout           =/* return array of 2 doubles for either ecliptic or equatorial coordinates, depending on calc_flag */
                    '<RETURN>: Nil


'[3]_swe_calc@24{swe_calc}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  702]:     ext_def(int32) swe_calc(double tjd, int ipl, int32 iflag,double *xx,char *serr);
'3.1.  The call parameters
'compute positions of planets, asteroids, lunar nodes and apogees.
'tjd_et requires Ephemeris Time (more accurate: Terrestrial Time (TT))
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_calc Lib "swedll32.dll" _
                    Alias "_swe_calc@24" ( _
                      ByVal tjd As Double, _
                      ByVal ipl As Long, _
                      ByVal iflag As Long, _
                      ByRef xx As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd            =//Julian Day Number, ET/TT
                    'ipl            =//fixed set of body numbers
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'xx             =//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[4]_swe_calc_pctr@28{swe_calc_pctr}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  710]:     ext_def(int32) swe_calc_pctr(double tjd, int32 ipl, int32 iplctr, int32 iflag, double *xxret, char *serr);
'3.         Planetary Positions: The functions swe_calc_ut(), swe_calc(), and swe_calc_pctr()
'calculates planetocentric positions of planets, i. e. positions as observed
'from some different planet, e.g. Jupiter-centric ephemerides. The function
'can actually calculate any object as observed from any other object,
'e.g. also the position of some asteroid as observed from another asteroid or
'from a planetary moon.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_calc_pctr Lib "swedll32.dll" _
                    Alias "_swe_calc_pctr@28" ( _
                      ByVal tjd As Double, _
                      ByVal ipl As Long, _
                      ByVal iplctr As Long, _
                      ByVal iflag As Long, _
                      ByRef xxret As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd            =//Julian Day Number, ET/TT
                    'ipl            =//fixed set of body numbers
                    'iplctr         =// center object
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'xxret          =//array of 6 doubles for planetary positions, planetocentric, from TT
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[5]_swe_calc_ut@24{swe_calc_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  707]:     ext_def(int32) swe_calc_ut(double tjd_ut, int32 ipl, int32 iflag, double *xx, char *serr);
'3.1.  The call parameters
'compute positions of planets, asteroids, lunar nodes and apogees.
'tjd_ut requires Universal Time (UT).
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_calc_ut Lib "swedll32.dll" _
                    Alias "_swe_calc_ut@24" ( _
                      ByVal tjd_ut As Double, _
                      ByVal ipl As Long, _
                      ByVal iflag As Long, _
                      ByRef xx As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'ipl            =//fixed set of body numbers
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'xx             =//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[6]_swe_close@0{swe_close}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  743]:     ext_def(void) swe_close(void);
'2.2.  swe_close()
'/* close Swiss Ephemeris */
'At the end of your computations you can release all resources (open files and allocated memory) used by the Swiss Ephemeris DLL.
'After swe_close(), no Swiss Ephemeris functions should be used unless you call swe_set_ephe_path() again and, if required, swe_set_jpl_file().
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_close Lib "swedll32.dll" _
                    Alias "_swe_close@0" ( _
                    ) 'No return
                    '<RETURN>: Nil


'[7]_swe_cotrans@16{swe_cotrans}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  966]:     ext_def(void) swe_cotrans(double *xpo, double *xpn, double eps);
'18.6.1.      swe_cotrans(): coordinate transformation,
'from ecliptic to equator or vice-versa
'/* equator -> ecliptic    : eps must be positive
'* ecliptic -> equator    : eps must be negative
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_cotrans Lib "swedll32.dll" _
                    Alias "_swe_cotrans@16" ( _
                      ByRef xpo As Double, _
                      ByRef xpn As Double, _
                      ByVal eps As Double _
                    ) 'No return
                    'xpo            =/* Array of 3 doubles: long., lat., dist. to be converted; distance remains unchanged, can be set to 1.00 */
                    'xpn            =/* Array of 3 doubles: long., lat., dist. Result of the conversion */
                    'eps            =//Obliquity of ecliptic, in Decimal degrees, equator -> ecliptic: +eps(+Ve) ,ecliptic -> equator : -eps (-Ve)
                    '<RETURN>: Nil


'[8]_swe_cotrans_sp@16{swe_cotrans_sp}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  967]:     ext_def(void) swe_cotrans_sp(double *xpo, double *xpn, double eps);
'18.6.2.      swe_cotrans_sp(): coordinate transformation of
'position and speed, from ecliptic to equator or vice-versa
'/ * equator -> ecliptic   : eps must be positive
'* ecliptic -> equator    : eps must be negative
'* eps, long., lat., and speeds in long. and lat. are in degrees! */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_cotrans_sp Lib "swedll32.dll" _
                    Alias "_swe_cotrans_sp@16" ( _
                      ByRef xpo As Double, _
                      ByRef xpn As Double, _
                      ByVal eps As Double _
                    ) 'No return
                    'xpo            =/* Array of 6 doubles, input: long., lat., dist. and speeds in long., lat and dist. */
                    'xpn            =/* Array of 6 doubles, position and speed in new coordinate system */
                    'eps            =//Obliquity of ecliptic, in Decimal degrees, equator -> ecliptic: +eps(+Ve) ,ecliptic -> equator : -eps (-Ve)
                    '<RETURN>: Nil


'[9]_swe_cs2degstr@8{swe_cs2degstr_LPCHARA}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1017]:     ext_def(char *) swe_cs2degstr(CSEC t, char *a);
'18.7.11.   Centiseconds -> degrees string
'/* does  suppress leading zeros in degrees */
'/* former function name: DegreeString() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_cs2degstr_LPCHARA Lib "swedll32.dll" _
                    Alias "_swe_cs2degstr@8" ( _
                      ByVal t As Long, _
                      ByVal a As String _
                    ) As Long
                    't              =// value in Centiseconds
                    'a              =//TimeString of Size 256
                    '<RETURN>: LongPointer to Array of Chars(String)


'[10]_swe_cs2lonlatstr@16{swe_cs2lonlatstr_LPCHARA}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1015]:     ext_def(char *) swe_cs2lonlatstr(CSEC t, char pchar, char mchar, char *s);
'18.7.10.   Centiseconds -> longitude or latitude string
'/* former function name: LonLatString() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_cs2lonlatstr_LPCHARA Lib "swedll32.dll" _
                    Alias "_swe_cs2lonlatstr@16" ( _
                      ByVal t As Long, _
                      ByVal pchar As Byte, _
                      ByVal mchar As Byte, _
                      ByVal s As String _
                    ) As Long
                    't              =// value in Centiseconds
                    'pchar          =//Char for calculation
                    'mchar          =//used in Centiseconds -> longitude or latitude string
                    's              =//longitude or latitude string
                    '<RETURN>: LongPointer to Array of Chars(String)


'[11]_swe_cs2timestr@16{swe_cs2timestr_LPCHARA}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1013]:     ext_def(char *) swe_cs2timestr(CSEC t, int sep, AS_BOOL suppressZero, char *a);
'18.7.9.      Centiseconds -> time string
'/* former function name: TimeString() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_cs2timestr_LPCHARA Lib "swedll32.dll" _
                    Alias "_swe_cs2timestr@16" ( _
                      ByVal t As Long, _
                      ByVal sep As Long, _
                      ByVal suppressZero As Long, _
                      ByVal a As String _
                    ) As Long
                    't              =// value in Centiseconds
                    'sep            =/* use in former function name: TimeString() */
                    'suppressZero   =/* Flag for Calculation. See user's manual */
                    'a              =//TimeString of Size 256
                    '<RETURN>: LongPointer to Array of Chars(String)


'[12]_swe_csnorm@4{swe_csnorm}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  991]:     ext_def(centisec) swe_csnorm(centisec p);
'18.7.1.      Normalize argument into interval [0..DEG360]
'/ * former function name: csnorm() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_csnorm Lib "swedll32.dll" _
                    Alias "_swe_csnorm@4" ( _
                      ByVal p As Long _
                    ) As Long
                    'p              =//Value in CentiSeconds
                    '<RETURN>: Long


'[13]_swe_csroundsec@4{swe_csroundsec}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1005]:     ext_def(centisec) swe_csroundsec(centisec x);
'18.7.6.      Round second, but at 29.5959 always down
'/* former function name: roundsec() */
'centisec swe_csroundsec(centisec x);
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_csroundsec Lib "swedll32.dll" _
                    Alias "_swe_csroundsec@4" ( _
                      ByVal x As Long _
                    ) As Long
                    'x              =//CentiSeconds
                    '<RETURN>: Long


'[14]_swe_d2l@8{swe_d2l}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1008]:     ext_def(int32) swe_d2l(double x);
'18.7.7.      Double to long with rounding, no overflow check
'/* former function name: d2l() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_d2l Lib "swedll32.dll" _
                    Alias "_swe_d2l@8" ( _
                      ByVal x As Double _
                    ) As Long
                    'x              =//double to long with rounding, no overflow check
                    '<RETURN>: Long


'[15]_swe_date_conversion@28{swe_date_conversion}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  776]:     ext_def(int) swe_date_conversion(int y , int m , int d , double utime, char c, double *tjd);
'9.1.  Calendar date and Julian day: swe_date_conversion()
'These functions are needed to convert calendar dates to the astronomical time scale which measures time in Julian days.
'compute a Julian day number from year, month, day, and hour and checks in addition
'whether the date is legal. It returns OK or ERR.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_date_conversion Lib "swedll32.dll" _
                    Alias "_swe_date_conversion@28" ( _
                      ByVal y As Long, _
                      ByVal m As Long, _
                      ByVal d As Long, _
                      ByVal utime As Double, _
                      ByVal c As Byte, _
                      ByRef tjd As Double _
                    ) As Long
                    'y              =//Year of the date
                    'm              =//Month of the date
                    'd              =//Day in the date
                    'utime          =/* hours (decimal, with fraction) */
                    'c              =/* calendar g[regorian] | j[ulian] */
                    'tjd            =//Julian Day Number
                    '<RETURN>: Long


'[16]_swe_day_of_week@8{swe_day_of_week}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1011]:     ext_def(int) swe_day_of_week(double jd);
'18.7.8.      Day of week Monday = 0, ... Sunday = 6
'/* former function name: day_of_week() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_day_of_week Lib "swedll32.dll" _
                    Alias "_swe_day_of_week@8" ( _
                      ByVal jd As Double _
                    ) As Long
                    'jd             =//Julian day Number
                    '<RETURN>: Long


'[17]_swe_deg_midp@16{swe_deg_midp}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  980]:     ext_def(double) swe_deg_midp(double x1, double x0);
'***********************(obsolete/Internal use)*******************
'/* finds midpoint of the arc from x0 to x1 range 0 ... 180*/
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_deg_midp Lib "swedll32.dll" _
                    Alias "_swe_deg_midp@16" ( _
                      ByVal x1 As Double, _
                      ByVal x0 As Double _
                    ) As Double
                    'x1             =//Value in Degree
                    'x0             =//Value in Degree
                    '<RETURN>: Double


'[18]_swe_degnorm@8{swe_degnorm}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  977]:     ext_def(double) swe_degnorm(double x);
'18.6.4.      swe_degnorm(): normalize degrees to the range 0 ... 360
'normalization of any degree number X to the range 0 ... 360
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_degnorm Lib "swedll32.dll" _
                    Alias "_swe_degnorm@8" ( _
                      ByVal x As Double _
                    ) As Double
                    'x              =//Value in Degree
                    '<RETURN>: Double


'[19]_swe_deltat@8{swe_deltat}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  952]:     ext_def(double) swe_deltat(double tjd);
'10.2.      swe_deltat() DeltaT calculation
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_deltat Lib "swedll32.dll" _
                    Alias "_swe_deltat@8" ( _
                      ByVal tjd As Double _
                    ) As Double
                    'tjd            =//Julian day, universal time (UT)
                    '<RETURN>: Double


'[20]_swe_deltat_ex@16{swe_deltat_ex}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  953]:     ext_def(double) swe_deltat_ex(double tjd, int32 iflag, char *serr);
'10.1.      swe_deltat_ex() ephemeris-dependent values of Delta T
'and is therefore better than the old function swe_deltat()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_deltat_ex Lib "swedll32.dll" _
                    Alias "_swe_deltat_ex@16" ( _
                      ByVal tjd As Double, _
                      ByVal iflag As Long, _
                      ByVal serr As String _
                    ) As Double
                    'tjd            =//Julian Day Number
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Double


'[21]_swe_difcs2n@8{swe_difcs2n}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  999]:     ext_def(centisec) swe_difcs2n(centisec p1, centisec p2);
'18.7.4.Distance in centisecs p1 - p2 normalized to [-180..180]
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_difcs2n Lib "swedll32.dll" _
                    Alias "_swe_difcs2n@8" ( _
                      ByVal p1 As Long, _
                      ByVal p2 As Long _
                    ) As Long
                    'p1             =//Distance in centisecs
                    'p2             =//Distance in centisecs
                    '<RETURN>: Long


'[22]_swe_difcsn@8{swe_difcsn}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  994]:     ext_def(centisec) swe_difcsn(centisec p1, centisec p2);
'18.7.2.      Distance in centisecs p1 - p2 normalized to [0..360]
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_difcsn Lib "swedll32.dll" _
                    Alias "_swe_difcsn@8" ( _
                      ByVal p1 As Long, _
                      ByVal p2 As Long _
                    ) As Long
                    'p1             =//Distance in centisecs
                    'p2             =//Distance in centisecs
                    '<RETURN>: Long


'[23]_swe_difdeg2n@16{swe_difdeg2n}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1001]:     ext_def(double) swe_difdeg2n(double p1, double p2);
'18.7.5.      Distance in degrees normalized to [0..180]???
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_difdeg2n Lib "swedll32.dll" _
                    Alias "_swe_difdeg2n@16" ( _
                      ByVal p1 As Double, _
                      ByVal p2 As Double _
                    ) As Double
                    'p1             =// Distance in degrees
                    'p2             =// Distance in degrees
                    '<RETURN>: Double


'[24]_swe_difdegn@16{swe_difdegn}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  996]:     ext_def(double) swe_difdegn(double p1, double p2);
'18.7.3.      Distance in degrees
'/* finds the difference in degree p1-p2 normilize 0 ...360*/
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_difdegn Lib "swedll32.dll" _
                    Alias "_swe_difdegn@16" ( _
                      ByVal p1 As Double, _
                      ByVal p2 As Double _
                    ) As Double
                    'p1             =// Distance in degrees
                    'p2             =// Distance in degrees
                    '<RETURN>: Double


'[25]_swe_difrad2n@16{swe_difrad2n}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[ 1002]:     ext_def(double) swe_difrad2n(double p1, double p2);
'***********************(obsolete/Internal use)*******************
'/* finds the difference of arc from p1-p0 normalize to 0 ... pi*/
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_difrad2n Lib "swedll32.dll" _
                    Alias "_swe_difrad2n@16" ( _
                      ByVal p1 As Double, _
                      ByVal p2 As Double _
                    ) As Double
                    'p1             =// Distance in radians
                    'p2             =// Distance in radians
                    '<RETURN>: Double


'[26]_swe_fixstar2@24{swe_fixstar2}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  732]:     ext_def(int32) swe_fixstar2(char *star, double tjd, int32 iflag,double *xx,char *serr);
'6.1.  Different functions for calculating fixed star positions
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_fixstar2 Lib "swedll32.dll" _
                    Alias "_swe_fixstar2@24" ( _
                      ByVal star As String, _
                      ByVal tjd As Double, _
                      ByVal iflag As Long, _
                      ByRef xx As Double, _
                      ByVal serr As String _
                    ) As Long
                    'star           =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'tjd            =//Julian Day Number, ET/TT
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'xx             =//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[27]_swe_fixstar2_mag@12{swe_fixstar2_mag}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  740]:     ext_def(int32) swe_fixstar2_mag(char *star, double *mag, char *serr);
'6.3.  swe_fixstar2_mag(), swe_fixstar_mag()
'Function calculates the magnitude of a fixed star.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_fixstar2_mag Lib "swedll32.dll" _
                    Alias "_swe_fixstar2_mag@12" ( _
                      ByVal star As String, _
                      ByRef mag As Double, _
                      ByVal serr As String _
                    ) As Long
                    'star           =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'mag            =//magnitude of a fixed star
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[28]_swe_fixstar2_ut@24{swe_fixstar2_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  737]:     ext_def(int32) swe_fixstar2_ut(char *star, double tjd_ut, int32 iflag, double *xx, char *serr);
'6.2.  swe_fixstar2_ut(), swe_fixstar2(), swe_fixstar_ut(), swe_fixstar()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_fixstar2_ut Lib "swedll32.dll" _
                    Alias "_swe_fixstar2_ut@24" ( _
                      ByVal star As String, _
                      ByVal tjd_ut As Double, _
                      ByVal iflag As Long, _
                      ByRef xx As Double, _
                      ByVal serr As String _
                    ) As Long
                    'star           =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'tjd_ut         =//Julian day, universal time (UT)
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'xx             =//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[29]_swe_fixstar@24{swe_fixstar}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  722]:     ext_def(int32) swe_fixstar(char *star, double tjd, int32 iflag,double *xx,char *serr);
'6.2.  swe_fixstar2_ut(), swe_fixstar2(), swe_fixstar_ut(), swe_fixstar()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_fixstar Lib "swedll32.dll" _
                    Alias "_swe_fixstar@24" ( _
                      ByVal star As String, _
                      ByVal tjd As Double, _
                      ByVal iflag As Long, _
                      ByRef xx As Double, _
                      ByVal serr As String _
                    ) As Long
                    'star           =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'tjd            =//Julian Day Number, ET/TT
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'xx             =//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[30]_swe_fixstar_mag@12{swe_fixstar_mag}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  730]:     ext_def(int32) swe_fixstar_mag(char *star, double *mag, char *serr);
'6.3.  swe_fixstar2_mag(), swe_fixstar_mag()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_fixstar_mag Lib "swedll32.dll" _
                    Alias "_swe_fixstar_mag@12" ( _
                      ByVal star As String, _
                      ByRef mag As Double, _
                      ByVal serr As String _
                    ) As Long
                    'star           =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'mag            =//magnitude of a fixed star
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[31]_swe_fixstar_ut@24{swe_fixstar_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  727]:     ext_def(int32) swe_fixstar_ut(char *star, double tjd_ut, int32 iflag, double *xx, char *serr);
'6.         Fixed stars functions
'6.2.  swe_fixstar2_ut(), swe_fixstar2(), swe_fixstar_ut(), swe_fixstar()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_fixstar_ut Lib "swedll32.dll" _
                    Alias "_swe_fixstar_ut@24" ( _
                      ByVal star As String, _
                      ByVal tjd_ut As Double, _
                      ByVal iflag As Long, _
                      ByRef xx As Double, _
                      ByVal serr As String _
                    ) As Long
                    'star           =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'tjd_ut         =//Julian day, universal time (UT)
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'xx             =//array of 6 doubles for longitude, latitude, distance, speed in long., speed in lat., and speed in dist.
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[32]_swe_gauquelin_sector@52{swe_gauquelin_sector}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  848]:     ext_def(int32) swe_gauquelin_sector(double t_ut, int32 ipl, char *starname, int32 iflag, int32 imeth, double *geopos, double atpress, double attemp, double *dgsect, char *serr);
'16.1.      Calculating the Gauquelin sector position of a planet with swe_house_pos() or swe_gauquelin_sector()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_gauquelin_sector Lib "swedll32.dll" _
                    Alias "_swe_gauquelin_sector@52" ( _
                      ByVal t_ut As Double, _
                      ByVal ipl As Long, _
                      ByVal starname As String, _
                      ByVal iflag As Long, _
                      ByVal imeth As Long, _
                      ByRef geopos As Double, _
                      ByVal atpress As Double, _
                      ByVal attemp As Double, _
                      ByRef dgsect As Double, _
                      ByVal serr As String _
                    ) As Long
                    't_ut           =/* input time JulianDay Number (UT) */
                    'ipl            =//fixed set of body numbers
                    'starname       =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'imeth          =/* method flag for Calculation*/
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'atpress        =/* atmospheric pressure in mbar/hPa */
                    'attemp         =// atmospheric temperature in degrees Celsius
                    'dgsect         =/* return address for Gauquelin sector position */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[33]_swe_get_astro_models@12{swe_get_astro_models}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  692]:     ext_def(void) swe_get_astro_models(char *samod, char *sdet, int32 iflag);
'***********************(obsolete/Internal use)*******************
'*WARNING:/* This function is for inhouse testing only */*******
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_get_astro_models Lib "swedll32.dll" _
                    Alias "_swe_get_astro_models@12" ( _
                      ByVal samod As String, _
                      ByVal sdet As String, _
                      ByVal iflag As Long _
                    ) 'No return
                    'samod          =//Model Name Internal use only
                    'sdet           =//String to hold internal use only
                    'iflag          =//Control Flag for internal use only
                    '<RETURN>: Nil


'[34]_swe_get_ayanamsa@8{swe_get_ayanamsa}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  763]:     ext_def(double) swe_get_ayanamsa(double tjd_et);
'12.2.      swe_get_ayanamsa_ex_ut(), swe_get_ayanamsa_ex(), swe_get_ayanamsa() and swe_get_ayanamsa_ut()
'provide the ayanamsha without nutation
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_get_ayanamsa Lib "swedll32.dll" _
                    Alias "_swe_get_ayanamsa@8" ( _
                      ByVal tjd_et As Double _
                    ) As Double
                    'tjd_et         =//julian Day Number in ET/TT
                    '<RETURN>: Double


'[35]_swe_get_ayanamsa_ex@20{swe_get_ayanamsa_ex}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  761]:     ext_def(int32) swe_get_ayanamsa_ex(double tjd_et, int32 iflag, double *daya, char *serr);
'12.2.      swe_get_ayanamsa_ex_ut(), swe_get_ayanamsa_ex(), swe_get_ayanamsa() and swe_get_ayanamsa_ut()
'provide the ayanamsha with or without nutation depending on the parameter iflag.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_get_ayanamsa_ex Lib "swedll32.dll" _
                    Alias "_swe_get_ayanamsa_ex@20" ( _
                      ByVal tjd_et As Double, _
                      ByVal iflag As Long, _
                      ByRef daya As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_et         =//julian Day Number in ET/TT
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'daya           =/* output: ayanamsha value (pointer to double) */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[36]_swe_get_ayanamsa_ex_ut@20{swe_get_ayanamsa_ex_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  762]:     ext_def(int32) swe_get_ayanamsa_ex_ut(double tjd_ut, int32 iflag, double *daya, char *serr);
'12.2.      swe_get_ayanamsa_ex_ut(), swe_get_ayanamsa_ex(), swe_get_ayanamsa() and swe_get_ayanamsa_ut()
'provide the ayanamsha with or without nutation depending on the parameter iflag.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_get_ayanamsa_ex_ut Lib "swedll32.dll" _
                    Alias "_swe_get_ayanamsa_ex_ut@20" ( _
                      ByVal tjd_ut As Double, _
                      ByVal iflag As Long, _
                      ByRef daya As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'daya           =/* output: ayanamsha value (pointer to double) */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[37]_swe_get_ayanamsa_name@4{swe_get_ayanamsa_name_LPCHARA}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  767]:     ext_def(const char *) swe_get_ayanamsa_name(int32 isidmode);
' 18.1.4.      Set the sidereal mode and get ayanamsha values
' find the name of an ayanamsha
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_get_ayanamsa_name_LPCHARA Lib "swedll32.dll" _
                    Alias "_swe_get_ayanamsa_name@4" ( _
                      ByVal isidmode As Long _
                    ) As Long
                    'isidmode       =//Ayanamsa Number
                    '<RETURN>: LongPointer to Array of Chars(String)


'[38]_swe_get_ayanamsa_ut@8{swe_get_ayanamsa_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  764]:     ext_def(double) swe_get_ayanamsa_ut(double tjd_ut);
'12.2.      swe_get_ayanamsa_ex_ut(), swe_get_ayanamsa_ex(), swe_get_ayanamsa() and swe_get_ayanamsa_ut()
'provide the ayanamsha without nutation.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_get_ayanamsa_ut Lib "swedll32.dll" _
                    Alias "_swe_get_ayanamsa_ut@8" ( _
                      ByVal tjd_ut As Double _
                    ) As Double
                    'tjd_ut         =//Julian day, universal time (UT)
                    '<RETURN>: Double


'[39]_swe_get_current_file_data@16{swe_get_current_file_data_LPCHARA}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  768]:     ext_def(const char *) swe_get_current_file_data(int ifno, double *tfstart, double *tfend, int *denum);
'2.6.  swe_get_current_file_data()
'This is function can be used to find out the start and end date of an *se1 ephemeris file after a call of swe_calc().
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_get_current_file_data_LPCHARA Lib "swedll32.dll" _
                    Alias "_swe_get_current_file_data@16" ( _
                      ByVal ifno As Long, _
                      ByRef tfstart As Double, _
                      ByRef tfend As Double, _
                      ByRef denum As Long _
                    ) As Long
                    'ifno           =//File Number flag (0 to 4)
                    'tfstart        =// start date of file,
                    'tfend          =//end data of file,
                    'denum          =// denum   = jpl ephemeris number 406 or 431 from which file was derived
                    '<RETURN>: LongPointer to Array of Chars(String)


'[40]_swe_get_library_path@4{swe_get_library_path_LPCHARA}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  699]:     ext_def(char *) swe_get_library_path(char *);
'2.5.  swe_get_library_path()
'/* find out the library path of the DLL or executable */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_get_library_path_LPCHARA Lib "swedll32.dll" _
                    Alias "_swe_get_library_path@4" ( _
                      ByVal s As String _
                    ) As Long
                    's              =//Return String  must be able to hold 256 bytes
                    '<RETURN>: LongPointer to Array of Chars(String)


'[41]_swe_get_orbital_elements@24{swe_get_orbital_elements}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  942]:     ext_def(int32) swe_get_orbital_elements(double tjd_et, int32 ipl, int32 iflag, double *dret, char *serr);
'7.2.  swe_get_orbital_elements() (Kepler elements and orbital data)
'This function calculates osculating elements (Kepler elements) and
'orbital periods for a planet, the Earth-Moon barycenter, or an asteroid.
'The elements are calculated relative to the mean ecliptic J2000.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_get_orbital_elements Lib "swedll32.dll" _
                    Alias "_swe_get_orbital_elements@24" ( _
                      ByVal tjd_et As Double, _
                      ByVal ipl As Long, _
                      ByVal iflag As Long, _
                      ByRef dret As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_et         =//julian Day Number in ET/TT
                    'ipl            =//fixed set of body numbers
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'dret           =/* result: Return array, See User's manual */Declare array of 50 doubles
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[42]_swe_get_planet_name@8{swe_get_planet_name_LPCHARA}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  752]:     ext_def(char *) swe_get_planet_name(int ipl, char *spname);
'5.         The function swe_get_planet_name()
'This function allows to find a planetary or asteroid name,
'when the planet number is given. The function definition is:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_get_planet_name_LPCHARA Lib "swedll32.dll" _
                    Alias "_swe_get_planet_name@8" ( _
                      ByVal ipl As Long, _
                      ByVal spname As String _
                    ) As Long
                    'ipl            =//fixed set of body numbers
                    'spname         =//Return Planet Name  must be able to hold 256 bytes
                    '<RETURN>: LongPointer to Array of Chars(String)


'[43]_swe_get_tid_acc@0{swe_get_tid_acc}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  970]:     ext_def(double) swe_get_tid_acc(void);
'18.3.9.      Get tidal acceleration used in swe_deltat()
'/* returns tidal acceleration used in swe_deltat() and swe_deltat_ex() */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_get_tid_acc Lib "swedll32.dll" _
                    Alias "_swe_get_tid_acc@0" ( _
                    ) As Double
                    '<RETURN>: Double


'[44]_swe_heliacal_angle@72{swe_heliacal_angle}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  686]:     ext_def(int32) swe_heliacal_angle(double tjdut, double *dgeo, double *datm, double *dobs, int32 helflag, double mag, double azi_obj, double azi_sun, double azi_moon, double alt_moon, double *dret, char *serr);
'***********************(obsolete/Internal use)*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_heliacal_angle Lib "swedll32.dll" _
                    Alias "_swe_heliacal_angle@72" ( _
                      ByVal tjdut As Double, _
                      ByRef dgeo As Double, _
                      ByRef datm As Double, _
                      ByRef dobs As Double, _
                      ByVal helflag As Long, _
                      ByVal mag As Double, _
                      ByVal azi_obj As Double, _
                      ByVal azi_sun As Double, _
                      ByVal azi_moon As Double, _
                      ByVal alt_moon As Double, _
                      ByRef dret As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjdut          =//Julian day, universal time (UT)
                    'dgeo           =/* geographic position (details User's manual) */declare array of 3 doubles
                    'datm           =/* atmospheric conditions (details User's manual) */declare array of 10 doubles
                    'dobs           =/* observer description (details User's manual) */declare array of 10 doubles
                    'helflag        =/* Flag for Calculation. See user's manual */
                    'mag            =//For internal use
                    'azi_obj        =//For internal use
                    'azi_sun        =//For internal use
                    'azi_moon       =//For internal use
                    'alt_moon       =//For internal use
                    'dret           =/* result: Return array, See User's manual */Declare array of 50 doubles
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[45]_swe_heliacal_pheno_ut@40{swe_heliacal_pheno_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  682]:     ext_def(int32) swe_heliacal_pheno_ut(double tjd_ut, double *geopos, double *datm, double *dobs, char *ObjectName, int32 TypeEvent, int32 helflag, double *darr, char *serr);
'***********************<>*******************
'8.19.      Heliacal details: swe_heliacal_pheno_ut()
'provides data that are relevant for the calculation of heliacal risings and settings.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_heliacal_pheno_ut Lib "swedll32.dll" _
                    Alias "_swe_heliacal_pheno_ut@40" ( _
                      ByVal tjd_ut As Double, _
                      ByRef geopos As Double, _
                      ByRef datm As Double, _
                      ByRef dobs As Double, _
                      ByVal ObjectName As String, _
                      ByVal TypeEvent As Long, _
                      ByVal helflag As Long, _
                      ByRef darr As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'datm           =/* atmospheric conditions (details User's manual) */declare array of 10 doubles
                    'dobs           =/* observer description (details User's manual) */declare array of 10 doubles
                    'ObjectName     =/* name string of fixed star or planet */ Name Size 40 Chars?
                    'TypeEvent      =/* event type */
                    'helflag        =/* Flag for Calculation. See user's manual */
                    'darr           =/* return array, declare array of 50 doubles */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[46]_swe_heliacal_ut@40{swe_heliacal_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  681]:     ext_def(int32) swe_heliacal_ut(double tjdstart_ut, double *geopos, double *datm, double *dobs, char *ObjectName, int32 TypeEvent, int32 iflag, double *dret, char *serr);
'8.17.      Heliacal risings etc.: swe_heliacal_ut()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_heliacal_ut Lib "swedll32.dll" _
                    Alias "_swe_heliacal_ut@40" ( _
                      ByVal tjdstart_ut As Double, _
                      ByRef geopos As Double, _
                      ByRef datm As Double, _
                      ByRef dobs As Double, _
                      ByVal ObjectName As String, _
                      ByVal TypeEvent As Long, _
                      ByVal iflag As Long, _
                      ByRef dret As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjdstart_ut    =//Julian day, universal time (UT)
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'datm           =/* atmospheric conditions (details User's manual) */declare array of 10 doubles
                    'dobs           =/* observer description (details User's manual) */declare array of 10 doubles
                    'ObjectName     =/* name string of fixed star or planet */ Name Size 40 Chars?
                    'TypeEvent      =/* event type */
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'dret           =/* result: Return array, See User's manual */Declare array of 50 doubles
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[47]_swe_helio_cross@36{swe_helio_cross}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  718]:     ext_def(int32) swe_helio_cross(int32 ipl, double x2cross, double jd_et, int32 iflag, int32 dir, double *jd_cross, char *serr);
'29.3.      Changes from version 2.10.01 to 2.10.02
'to find crossings of planets over fixed positions:
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_helio_cross Lib "swedll32.dll" _
                    Alias "_swe_helio_cross@36" ( _
                      ByVal ipl As Long, _
                      ByVal x2cross As Double, _
                      ByVal jd_et As Double, _
                      ByVal iflag As Long, _
                      ByVal dir As Long, _
                      ByRef jd_cross As Double, _
                      ByVal serr As String _
                    ) As Long
                    'ipl            =//fixed set of body numbers
                    'x2cross        =//heliocentric crossings over a position x2cross
                    'jd_et          =//Julian day, Ephemeris time/TT
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'dir            =//dir >= 0 indicates search forward in time, dir < 0 indicates search backward in time. It is recommended to use dir = 1 or dir = -1.
                    'jd_cross       =//Julianday Number
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[48]_swe_helio_cross_ut@36{swe_helio_cross_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  719]:     ext_def(int32) swe_helio_cross_ut(int32 ipl, double x2cross, double jd_ut, int32 iflag, int32 dir, double *jd_cross, char *serr);
'4.         Functions to find crossings of planets over positions
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_helio_cross_ut Lib "swedll32.dll" _
                    Alias "_swe_helio_cross_ut@36" ( _
                      ByVal ipl As Long, _
                      ByVal x2cross As Double, _
                      ByVal jd_ut As Double, _
                      ByVal iflag As Long, _
                      ByVal dir As Long, _
                      ByRef jd_cross As Double, _
                      ByVal serr As String _
                    ) As Long
                    'ipl            =//fixed set of body numbers
                    'x2cross        =//heliocentric crossings over a position x2cross
                    'jd_ut          =//Julian day, universal time (UT)
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'dir            =//dir >= 0 indicates search forward in time, dir < 0 indicates search backward in time. It is recommended to use dir = 1 or dir = -1.
                    'jd_cross       =//Julianday Number
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[49]_swe_house_name@4{swe_house_name_LPCHARA}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  840]:     ext_def(char *) swe_house_name(int hsys);
'15.1.      swe_house_name()
'/* returns the name of the house method, maximum 40 chars */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_house_name_LPCHARA Lib "swedll32.dll" _
                    Alias "_swe_house_name@4" ( _
                      ByVal hsys As Long _
                    ) As Long
                    'hsys           =//House Division Number
                    '<RETURN>: LongPointer to Array of Chars(String)


'[50]_swe_house_pos@36{swe_house_pos}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  837]:     ext_def(double) swe_house_pos(double armc, double geolat, double eps, int hsys, double *xpin, char *serr);
'16.     House position of a planet: swe_house_pos()
'To compute the house position of a given body for a given ARMC
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_house_pos Lib "swedll32.dll" _
                    Alias "_swe_house_pos@36" ( _
                      ByVal armc As Double, _
                      ByVal geolat As Double, _
                      ByVal eps As Double, _
                      ByVal hsys As Long, _
                      ByRef xpin As Double, _
                      ByVal serr As String _
                    ) As Double
                    'armc           =//right ascension of meridian collie
                    'geolat         =// latitude,northern is positive & southern is negative
                    'eps            =//Obliquity of ecliptic, in Decimal degrees
                    'hsys           =/* house method, ascii code of one of the letters PKORCAEVXHTBG */
                    'xpin           =/* array of 2 doubles: ecl. longitude and latitude of the planet */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Double


'[51]_swe_houses@36{swe_houses}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  817]:     ext_def(int) swe_houses(double tjd_ut, double geolat, double geolon, int hsys, double *cusps, double *ascmc);
'15.2.      swe_houses()
'/* house cusps, ascendant and MC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_houses Lib "swedll32.dll" _
                    Alias "_swe_houses@36" ( _
                      ByVal tjd_ut As Double, _
                      ByVal geolat As Double, _
                      ByVal geolon As Double, _
                      ByVal hsys As Long, _
                      ByRef cusps As Double, _
                      ByRef ascmc As Double _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'geolat         =// latitude,northern is positive & southern is negative
                    'geolon         =// geographic longitude,East is positive & West is negative
                    'hsys           =/* house method, ascii code of one of the letters PKORCAEVXHTBG */
                    'cusps          =/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
                    'ascmc          =/* array of 10 doubles, explained in Manual*/
                    '<RETURN>: Long


'[52]_swe_houses_armc@36{swe_houses_armc}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  829]:     ext_def(int) swe_houses_armc(double armc, double geolat, double eps, int hsys, double *cusps, double *ascmc);
'15.3.      swe_houses_armc() and swe_houses_armc_ex2()
'/* house cusps, ascendant and MC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_houses_armc Lib "swedll32.dll" _
                    Alias "_swe_houses_armc@36" ( _
                      ByVal armc As Double, _
                      ByVal geolat As Double, _
                      ByVal eps As Double, _
                      ByVal hsys As Long, _
                      ByRef cusps As Double, _
                      ByRef ascmc As Double _
                    ) As Long
                    'armc           =//right ascension of meridian collie in degrees
                    'geolat         =// latitude,northern is positive & southern is negative
                    'eps            =//Obliquity of ecliptic, in Decimal degrees
                    'hsys           =/* house method, ascii code of one of the letters PKORCAEVXHTBG */
                    'cusps          =/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
                    'ascmc          =/* array of 10 doubles, explained in Manual*/
                    '<RETURN>: Long


'[53]_swe_houses_armc_ex2@48{swe_houses_armc_ex2}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  833]:     ext_def(int) swe_houses_armc_ex2(double armc, double geolat, double eps, int hsys, double *cusps, double *ascmc, double *cusp_speed, double *ascmc_speed, char *serr);
'15.3.      swe_houses_armc() and swe_houses_armc_ex2()
'/* house cusps, ascendant and MC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_houses_armc_ex2 Lib "swedll32.dll" _
                    Alias "_swe_houses_armc_ex2@48" ( _
                      ByVal armc As Double, _
                      ByVal geolat As Double, _
                      ByVal eps As Double, _
                      ByVal hsys As Long, _
                      ByRef cusps As Double, _
                      ByRef ascmc As Double, _
                      ByRef cusp_speed As Double, _
                      ByRef ascmc_speed As Double, _
                      ByVal serr As String _
                    ) As Long
                    'armc           =//right ascension of meridian collie
                    'geolat         =// latitude,northern is positive & southern is negative
                    'eps            =//Obliquity of ecliptic, in Decimal degrees
                    'hsys           =/* house method, ascii code of one of the letters PKORCAEVXHTBG */
                    'cusps          =/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
                    'ascmc          =/* array of 10 doubles, explained in Manual*/
                    'cusp_speed     =/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
                    'ascmc_speed    =/* array of 10 doubles, explained in Manual*/
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[54]_swe_houses_ex2@52{swe_houses_ex2}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  825]:     ext_def(int) swe_houses_ex2(double tjd_ut, int32 iflag, double geolat, double geolon, int hsys, double *cusps, double *ascmc, double *cusp_speed, double *ascmc_speed, char *serr);
'15.4.      swe_houses_ex() and swe_houses_ex2()
'/* extended function; to compute tropical or sidereal positions of house cusps */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_houses_ex2 Lib "swedll32.dll" _
                    Alias "_swe_houses_ex2@52" ( _
                      ByVal tjd_ut As Double, _
                      ByVal iflag As Long, _
                      ByVal geolat As Double, _
                      ByVal geolon As Double, _
                      ByVal hsys As Long, _
                      ByRef cusps As Double, _
                      ByRef ascmc As Double, _
                      ByRef cusp_speed As Double, _
                      ByRef ascmc_speed As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'geolat         =// latitude,northern is positive & southern is negative
                    'geolon         =// geographic longitude,East is positive & West is negative
                    'hsys           =/* house method, ascii code of one of the letters PKORCAEVXHTBG */
                    'cusps          =/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
                    'ascmc          =/* array of 10 doubles, explained in Manual*/
                    'cusp_speed     =/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
                    'ascmc_speed    =/* array of 10 doubles, explained in Manual*/
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[55]_swe_houses_ex@40{swe_houses_ex}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  821]:     ext_def(int) swe_houses_ex(double tjd_ut, int32 iflag, double geolat, double geolon, int hsys, double *cusps, double *ascmc);
'15.4.      swe_houses_ex() and swe_houses_ex2()
'/* extended function; to compute tropical or sidereal positions of house cusps */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_houses_ex Lib "swedll32.dll" _
                    Alias "_swe_houses_ex@40" ( _
                      ByVal tjd_ut As Double, _
                      ByVal iflag As Long, _
                      ByVal geolat As Double, _
                      ByVal geolon As Double, _
                      ByVal hsys As Long, _
                      ByRef cusps As Double, _
                      ByRef ascmc As Double _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'geolat         =// latitude,northern is positive & southern is negative
                    'geolon         =// geographic longitude,East is positive & West is negative
                    'hsys           =/* house method, ascii code of one of the letters PKORCAEVXHTBG */
                    'cusps          =/* array of 13 (or 37 for hsys G) doubles, explained further User's manual */
                    'ascmc          =/* array of 10 doubles, explained in Manual*/
                    '<RETURN>: Long


'[56]_swe_jdet_to_utc@36{swe_jdet_to_utc}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  796]:     ext_def(void) swe_jdet_to_utc(double tjd_et, int32 gregflag, int32 *iyear, int32 *imonth, int32 *iday, int32 *ihour, int32 *imin, double *dsec);
'18.3.7.      TT (ET1) to UTC
'/* input: Julian day number in ET (TT), calendar flag
'/* output: year, month, day, hour, min, sec in UTC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_jdet_to_utc Lib "swedll32.dll" _
                    Alias "_swe_jdet_to_utc@36" ( _
                      ByVal tjd_et As Double, _
                      ByVal gregflag As Long, _
                      ByRef iyear As Long, _
                      ByRef imonth As Long, _
                      ByRef iday As Long, _
                      ByRef ihour As Long, _
                      ByRef imin As Long, _
                      ByRef dsec As Double _
                    ) 'No return
                    'tjd_et         =//julian Day Number in ET/TT
                    'gregflag       =/*calendars Flag for Calculation.See User's manual */
                    'iyear          =//Year in the date
                    'imonth         =//Month in the date
                    'iday           =//Day in the date
                    'ihour          =//Integer part of  Decimal hour
                    'imin           =//Integer minute part of  Decimal hour
                    'dsec           =//Decimal Seconds
                    '<RETURN>: Nil


'[57]_swe_jdut1_to_utc@36{swe_jdut1_to_utc}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  801]:     ext_def(void) swe_jdut1_to_utc(double tjd_ut, int32 gregflag, int32 *iyear, int32 *imonth, int32 *iday, int32 *ihour, int32 *imin, double *dsec);
'18.3.8.      UTC to TT (ET1)
'/* input: Julian day number in UT (UT1), calendar flag
'/* output: year, month, day, hour, min, sec in UTC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_jdut1_to_utc Lib "swedll32.dll" _
                    Alias "_swe_jdut1_to_utc@36" ( _
                      ByVal tjd_ut As Double, _
                      ByVal gregflag As Long, _
                      ByRef iyear As Long, _
                      ByRef imonth As Long, _
                      ByRef iday As Long, _
                      ByRef ihour As Long, _
                      ByRef imin As Long, _
                      ByRef dsec As Double _
                    ) 'No return
                    'tjd_ut         =//Julian day, universal time (UT)
                    'gregflag       =/*calendars Flag for Calculation.See User's manual */
                    'iyear          =//Year in the date
                    'imonth         =//Month in the date
                    'iday           =//Day in the date
                    'ihour          =//Integer part of  Decimal hour
                    'imin           =//Integer minute part of  Decimal hour
                    'dsec           =//Decimal Seconds
                    '<RETURN>: Nil


'[58]_swe_julday@24{swe_julday}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  782]:     ext_def(double) swe_julday(int year, int month, int day, double hour,int gregflag);
'9.         Date and time conversion functions
'9.1.  Calendar date and Julian day: swe_julday(), swe_date_conversion(), /swe_revjul()
'These functions converts calendar dates to the astronomical time scale which measures time in Julian days.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_julday Lib "swedll32.dll" _
                    Alias "_swe_julday@24" ( _
                      ByVal year As Long, _
                      ByVal month As Long, _
                      ByVal day As Long, _
                      ByVal hour As Double, _
                      ByVal gregflag As Long _
                    ) As Double
                    'year           =//Year of the date
                    'month          =//Month of the date
                    'day            =//Day in the date
                    'hour           =//Time in decimal Hours
                    'gregflag       =/*calendars Flag for Calculation.See User's manual */
                    '<RETURN>: Double


'[59]_swe_lat_to_lmt@24{swe_lat_to_lmt}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  958]:     ext_def(int32) swe_lat_to_lmt(double tjd_lat, double geolon, double *tjd_lmt, char *serr);
'9.4.  Mean solar time versus True solar time: swe_time_equ(), swe_lmt_to_lat(), swe_lat_to_lmt()
'/* converts Local Apparent Time (LAT) to Local Mean Time (LMT) */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_lat_to_lmt Lib "swedll32.dll" _
                    Alias "_swe_lat_to_lmt@24" ( _
                      ByVal tjd_lat As Double, _
                      ByVal geolon As Double, _
                      ByRef tjd_lmt As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_lat        =//julian Day Number for Local Apparent Time
                    'geolon         =// geographic longitude,East is positive & West is negative
                    'tjd_lmt        =//Julian Day Number Local Mean Time (LMT)
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[60]_swe_lmt_to_lat@24{swe_lmt_to_lat}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  957]:     ext_def(int32) swe_lmt_to_lat(double tjd_lmt, double geolon, double *tjd_lat, char *serr);
'9.4.  Mean solar time versus True solar time: swe_time_equ(), swe_lmt_to_lat(), swe_lat_to_lmt()
'/* converts Local Mean Time (LMT) to Local Apparent Time (LAT) */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_lmt_to_lat Lib "swedll32.dll" _
                    Alias "_swe_lmt_to_lat@24" ( _
                      ByVal tjd_lmt As Double, _
                      ByVal geolon As Double, _
                      ByRef tjd_lat As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_lmt        =//julian Day Number for Local Mean Time
                    'geolon         =// geographic longitude,East is positive & West is negative
                    'tjd_lat        =//Julian Day Number Local Apparent Time (LAT)
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[61]_swe_lun_eclipse_how@24{swe_lun_eclipse_how}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  874]:     ext_def(int32) swe_lun_eclipse_how(double tjd_ut,int32 ifl,double *geopos,double *attr,char *serr);
'8.11.      swe_lun_eclipse_how ()
'This function computes the attributes of a lunar eclipse at a given time:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_lun_eclipse_how Lib "swedll32.dll" _
                    Alias "_swe_lun_eclipse_how@24" ( _
                      ByVal tjd_ut As Double, _
                      ByVal ifl As Long, _
                      ByRef geopos As Double, _
                      ByRef attr As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'ifl            =/* Ephemeris Flag for Calculation. See user's manual */
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'attr           =/* return array of 20 doubles, see user's manual*/
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[62]_swe_lun_eclipse_when@28{swe_lun_eclipse_when}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  881]:     ext_def(int32) swe_lun_eclipse_when(double tjd_start, int32 ifl, int32 ifltype,double *tret, int32 backward, char *serr);
'8.10.      swe_lun_eclipse_when ()
'To find the next lunar eclipse:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_lun_eclipse_when Lib "swedll32.dll" _
                    Alias "_swe_lun_eclipse_when@28" ( _
                      ByVal tjd_start As Double, _
                      ByVal ifl As Long, _
                      ByVal ifltype As Long, _
                      ByRef tret As Double, _
                      ByVal backward As Long, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_start      =/* start date for search, Jul. day UT */
                    'ifl            =/* Ephemeris Flag for Calculation. See user's manual */
                    'ifltype        =/* Flag for Calculation. See user's manual */
                    'tret           =//Time details /* return array, Array of 10 doubles, see User's manual */
                    'backward       =/* TRUE, if backward search */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[63]_swe_lun_eclipse_when_loc@32{swe_lun_eclipse_when_loc}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  884]:     ext_def(int32) swe_lun_eclipse_when_loc(double tjd_start, int32 ifl,double *geopos, double *tret, double *attr, int32 backward, char *serr);
'8.9.  swe_lun_eclipse_when_loc ()
'To find the next lunar eclipse observable from a given geographic position:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_lun_eclipse_when_loc Lib "swedll32.dll" _
                    Alias "_swe_lun_eclipse_when_loc@32" ( _
                      ByVal tjd_start As Double, _
                      ByVal ifl As Long, _
                      ByRef geopos As Double, _
                      ByRef tret As Double, _
                      ByRef attr As Double, _
                      ByVal backward As Long, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_start      =/* start date for search, Jul. day UT */
                    'ifl            =/* Ephemeris Flag for Calculation. See user's manual */
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'tret           =//Time details /* return array, array of 10 doubles, see User's manual */
                    'attr           =/* return array of 20 doubles, see user's manual*/
                    'backward       =/* TRUE, if backward search */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[64]_swe_lun_occult_when_glob@36{swe_lun_occult_when_glob}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  870]:     ext_def(int32) swe_lun_occult_when_glob(double tjd_start, int32 ipl, char *starname, int32 ifl, int32 ifltype,double *tret, int32 backward, char *serr);
'8.7.  swe_lun_occult_when_glob()
'To find the next occultation of a planet or star by the moon globally
'(not for a particular geographic location),use swe_lun_occult_when_glob().
'The same function can also be used for global solar eclipses instead of
'swe_sol_eclipse_when_glob(), but is a bit less efficient.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_lun_occult_when_glob Lib "swedll32.dll" _
                    Alias "_swe_lun_occult_when_glob@36" ( _
                      ByVal tjd_start As Double, _
                      ByVal ipl As Long, _
                      ByVal starname As String, _
                      ByVal ifl As Long, _
                      ByVal ifltype As Long, _
                      ByRef tret As Double, _
                      ByVal backward As Long, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_start      =/* start date for search, Jul. day UT */
                    'ipl            =//fixed set of body numbers
                    'starname       =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'ifl            =/* Ephemeris Flag for Calculation. See user's manual */
                    'ifltype        =/* Flag for Calculation. See user's manual */
                    'tret           =//Time details /* return array, Array of 10 doubles, see User's manual */
                    'backward       =/* TRUE, if backward search */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[65]_swe_lun_occult_when_loc@40{swe_lun_occult_when_loc}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  862]:     ext_def(int32) swe_lun_occult_when_loc(double tjd_start, int32 ipl, char *starname, int32 ifl,double *geopos, double *tret, double *attr, int32 backward, char *serr);
'8.6.  swe_lun_occult_when_loc()
'To find the next occultation of a planet or star by the moon for a given location
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_lun_occult_when_loc Lib "swedll32.dll" _
                    Alias "_swe_lun_occult_when_loc@40" ( _
                      ByVal tjd_start As Double, _
                      ByVal ipl As Long, _
                      ByVal starname As String, _
                      ByVal ifl As Long, _
                      ByRef geopos As Double, _
                      ByRef tret As Double, _
                      ByRef attr As Double, _
                      ByVal backward As Long, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_start      =/* start date for search, Jul. day UT */
                    'ipl            =//fixed set of body numbers
                    'starname       =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'ifl            =/* Ephemeris Flag for Calculation. See user's manual */
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'tret           =//Time details /* return array, Array of 10 doubles, see User's manual */
                    'attr           =/* return array of 20 doubles, see user's manual*/
                    'backward       =/* TRUE, if backward search */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[66]_swe_lun_occult_where@32{swe_lun_occult_where}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  854]:     ext_def(int32) swe_lun_occult_where(double tjd, int32 ipl, char *starname, int32 ifl, double *geopos, double *attr, char *serr);
'8.8.  swe_lun_occult_where ()
'Similar to swe_sol_eclipse_where(), this function can be used
'to find out the geographic position, where, for a given time,
'a central eclipse is central or where a non-central eclipse is maximal.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_lun_occult_where Lib "swedll32.dll" _
                    Alias "_swe_lun_occult_where@32" ( _
                      ByVal tjd As Double, _
                      ByVal ipl As Long, _
                      ByVal starname As String, _
                      ByVal ifl As Long, _
                      ByRef geopos As Double, _
                      ByRef attr As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd            =//Julian Day Number
                    'ipl            =//fixed set of body numbers
                    'starname       =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'ifl            =/* Ephemeris Flag for Calculation. See user's manual */
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'attr           =/* return array of 20 doubles, see user's manual*/
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[67]_swe_mooncross@24{swe_mooncross}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  714]:     ext_def(double) swe_mooncross(double x2cross, double jd_et, int32 flag, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Moon over a given ecliptic position:
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_mooncross Lib "swedll32.dll" _
                    Alias "_swe_mooncross@24" ( _
                      ByVal x2cross As Double, _
                      ByVal jd_et As Double, _
                      ByVal flag As Long, _
                      ByVal serr As String _
                    ) As Double
                    'x2cross        =//heliocentric crossings over a position x2cross
                    'jd_et          =//Julian day, Ephemeris time/TT
                    'flag           =/* Flag for Calculation. See user's manual */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Double


'[68]_swe_mooncross_node@24{swe_mooncross_node}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  716]:     ext_def(double) swe_mooncross_node(double jd_et, int32 flag, double *xlon, double *xlat, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Moon over its true node,
'i.e. crossing through the ecliptic.
'/*compute next Moon crossing over node, by finding zero latitude crossing
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_mooncross_node Lib "swedll32.dll" _
                    Alias "_swe_mooncross_node@24" ( _
                      ByVal jd_et As Double, _
                      ByVal flag As Long, _
                      ByRef xlon As Double, _
                      ByRef xlat As Double, _
                      ByVal serr As String _
                    ) As Double
                    'jd_et          =//Julian day, Ephemeris time/TT
                    'flag           =/* Flag for Calculation. See user's manual */
                    'xlon           =//Longitude in Degrees
                    'xlat           =//Latitude in Degrees
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Double


'[69]_swe_mooncross_node_ut@24{swe_mooncross_node_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  717]:     ext_def(double) swe_mooncross_node_ut(double jd_ut, int32 flag, double *xlon, double *xlat, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Moon over its true node,
'i.e. crossing through the ecliptic.
'/*compute next Moon crossing over node, by finding zero latitude crossing
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_mooncross_node_ut Lib "swedll32.dll" _
                    Alias "_swe_mooncross_node_ut@24" ( _
                      ByVal jd_ut As Double, _
                      ByVal flag As Long, _
                      ByRef xlon As Double, _
                      ByRef xlat As Double, _
                      ByVal serr As String _
                    ) As Double
                    'jd_ut          =//Julian day, universal time (UT)
                    'flag           =/* Flag for Calculation. See user's manual */
                    'xlon           =//Longitude in Degrees
                    'xlat           =//Latitude in Degrees
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Double


'[70]_swe_mooncross_ut@24{swe_mooncross_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  715]:     ext_def(double) swe_mooncross_ut(double x2cross, double jd_ut, int32 flag, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Moon over a given ecliptic position:
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_mooncross_ut Lib "swedll32.dll" _
                    Alias "_swe_mooncross_ut@24" ( _
                      ByVal x2cross As Double, _
                      ByVal jd_ut As Double, _
                      ByVal flag As Long, _
                      ByVal serr As String _
                    ) As Double
                    'x2cross        =//heliocentric crossings over a position x2cross
                    'jd_ut          =//Julian day, universal time (UT)
                    'flag           =/* Flag for Calculation. See user's manual */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Double


'[71]_swe_nod_aps@40{swe_nod_aps}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  931]:     ext_def(int32) swe_nod_aps(double tjd_et, int32 ipl, int32 iflag,int32 method,double *xnasc, double *xndsc,double *xperi, double *xaphe,char *serr);
'7.         Apsides and nodes, Kepler elements and orbital periods
'7.1.  swe_nod_aps_ut() and swe_nod_aps()
'compute planetary nodes and apsides (perihelia, aphelia,
'second focal points of the orbital ellipses).
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_nod_aps Lib "swedll32.dll" _
                    Alias "_swe_nod_aps@40" ( _
                      ByVal tjd_et As Double, _
                      ByVal ipl As Long, _
                      ByVal iflag As Long, _
                      ByVal method As Long, _
                      ByRef xnasc As Double, _
                      ByRef xndsc As Double, _
                      ByRef xperi As Double, _
                      ByRef xaphe As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_et         =//julian Day Number in ET/TT
                    'ipl            =//fixed set of body numbers
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'method         =/* Flag for Calculation. See user's manual */
                    'xnasc          =// array of 6 double for ascending node
                    'xndsc          =// array of 6 double for ascending node
                    'xperi          =// array of 6 double for perihelion
                    'xaphe          =/* array of 6 double for aphelion*/
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[72]_swe_nod_aps_ut@40{swe_nod_aps_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  937]:     ext_def(int32) swe_nod_aps_ut(double tjd_ut, int32 ipl, int32 iflag,int32 method,double *xnasc, double *xndsc,double *xperi, double *xaphe,char *serr);
'7.         Apsides and nodes, Kepler elements and orbital periods
'7.1.  swe_nod_aps_ut() and swe_nod_aps()
'modified version of swe_nod_aps
'compute planetary nodes and apsides (perihelia, aphelia,
'second focal points of the orbital ellipses).
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_nod_aps_ut Lib "swedll32.dll" _
                    Alias "_swe_nod_aps_ut@40" ( _
                      ByVal tjd_ut As Double, _
                      ByVal ipl As Long, _
                      ByVal iflag As Long, _
                      ByVal method As Long, _
                      ByRef xnasc As Double, _
                      ByRef xndsc As Double, _
                      ByRef xperi As Double, _
                      ByRef xaphe As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'ipl            =//fixed set of body numbers
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'method         =/* Flag for Calculation. See user's manual */
                    'xnasc          =// array of 6 double for ascending node
                    'xndsc          =// array of 6 double for ascending node
                    'xperi          =// array of 6 double for perihelion
                    'xaphe          =/* array of 6 double for aphelion*/
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[73]_swe_orbit_max_min_true_distance@32{swe_orbit_max_min_true_distance}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  945]:     ext_def(int32) swe_orbit_max_min_true_distance(double tjd_et, int32 ipl, int32 iflag, double *dmax, double *dmin, double *dtrue, char *serr);
'7.3.  swe_orbit_max_min_true_distance()
'This function calculates the maximum possible distance,
'the minimum possible distance, and the current true distance
'of planet,the EMB, or an asteroid.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_orbit_max_min_true_distance Lib "swedll32.dll" _
                    Alias "_swe_orbit_max_min_true_distance@32" ( _
                      ByVal tjd_et As Double, _
                      ByVal ipl As Long, _
                      ByVal iflag As Long, _
                      ByRef dmax As Double, _
                      ByRef dmin As Double, _
                      ByRef dtrue As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_et         =//julian Day Number in ET/TT
                    'ipl            =//fixed set of body numbers
                    'iflag          =/* ephemeris flag and optional heliocentric flag for Calculation. See user's manual */
                    'dmax           =// return value: maximum distance based on osculating elements
                    'dmin           =// return value: minimum distance based on osculating elements
                    'dtrue          =// return value: current distance
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[74]_swe_pheno@24{swe_pheno}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  888]:     ext_def(int32) swe_pheno(double tjd, int32 ipl, int32 iflag, double *attr, char *serr);
'8.13.      swe_pheno_ut() and swe_pheno(), planetary phenomena
'These functions compute phase, phase angle, elongation, apparent diameter,
'apparent magnitude for the Sun, the Moon, all planets and asteroids.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_pheno Lib "swedll32.dll" _
                    Alias "_swe_pheno@24" ( _
                      ByVal tjd As Double, _
                      ByVal ipl As Long, _
                      ByVal iflag As Long, _
                      ByRef attr As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd            =//Julian Day Number, ET/TT
                    'ipl            =//fixed set of body numbers
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'attr           =/* return array of 20 doubles, see user's manual*/
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[75]_swe_pheno_ut@24{swe_pheno_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  890]:     ext_def(int32) swe_pheno_ut(double tjd_ut, int32 ipl, int32 iflag, double *attr, char *serr);
'8.13.      swe_pheno_ut() and swe_pheno(), planetary phenomena
'These functions compute phase, phase angle, elongation, apparent diameter,
'apparent magnitude for the Sun, the Moon, all planets and asteroids.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_pheno_ut Lib "swedll32.dll" _
                    Alias "_swe_pheno_ut@24" ( _
                      ByVal tjd_ut As Double, _
                      ByVal ipl As Long, _
                      ByVal iflag As Long, _
                      ByRef attr As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'ipl            =//fixed set of body numbers
                    'iflag          =/* Flag for Calculation. See user's manual */
                    'attr           =/* return array of 20 doubles, see user's manual*/
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[76]_swe_rad_midp@16{swe_rad_midp}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  979]:     ext_def(double) swe_rad_midp(double x1, double x0);
'***********************(obsolete/Internal use)*******************
'/* finds midpoint of the arc from x0 to x1 radian range 0 ... pi*/
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_rad_midp Lib "swedll32.dll" _
                    Alias "_swe_rad_midp@16" ( _
                      ByVal x1 As Double, _
                      ByVal x0 As Double _
                    ) As Double
                    'x1             =//Value in Radian
                    'x0             =//Value in Radian
                    '<RETURN>: Double


'[77]_swe_radnorm@8{swe_radnorm}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  978]:     ext_def(double) swe_radnorm(double x);
'18.6.5.      swe_radnorm(): normalize radians to the range 0 ... 2 PI
'normalize x radians to the range 0 ... 2phi
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_radnorm Lib "swedll32.dll" _
                    Alias "_swe_radnorm@8" ( _
                      ByVal x As Double _
                    ) As Double
                    'x              =//Value in Radian
                    '<RETURN>: Double


'[78]_swe_refrac@28{swe_refrac}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  892]:     ext_def(double) swe_refrac(double inalt, double atpress, double attemp, int32 calc_flag);
'8.16.      swe_refrac(), swe_refrac_extended(), refraction
'This refraction function calculates either the true altitude from
'the apparent altitude or the apparent altitude from the apparent altitude.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_refrac Lib "swedll32.dll" _
                    Alias "_swe_refrac@28" ( _
                      ByVal inalt As Double, _
                      ByVal atpress As Double, _
                      ByVal attemp As Double, _
                      ByVal calc_flag As Long _
                    ) As Double
                    'inalt          =/* altitude of object above geometric horizon in degrees, where geometric horizon = plane perpendicular to gravity */
                    'atpress        =/* atmospheric pressure in mbar/hPa */
                    'attemp         =// atmospheric temperature in degrees Celsius
                    'calc_flag      =/* Flag for Calculation. See user's manual */
                    '<RETURN>: Double


'[79]_swe_refrac_extended@48{swe_refrac_extended}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  894]:     ext_def(double) swe_refrac_extended(double inalt, double geoalt, double atpress, double attemp, double lapse_rate, int32 calc_flag, double *dret);
'8.16.      swe_refrac(), swe_refrac_extended(), refraction
'This refraction function calculates either the true altitude from
'the apparent altitude or the apparent altitude from the apparent altitude.
'It allows correct calculation of refraction for altitudes above sea > 0,
'where the ideal horizon and planets that are visible may have a negative
'height. (for swe_refrac(), negative apparent heights do not exist!)
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_refrac_extended Lib "swedll32.dll" _
                    Alias "_swe_refrac_extended@48" ( _
                      ByVal inalt As Double, _
                      ByVal geoalt As Double, _
                      ByVal atpress As Double, _
                      ByVal attemp As Double, _
                      ByVal lapse_rate As Double, _
                      ByVal calc_flag As Long, _
                      ByRef dret As Double _
                    ) As Double
                    'inalt          =/* altitude of object above geometric horizon in degrees, where geometric horizon = plane perpendicular to gravity */
                    'geoalt         =/* altitude of observer above sea level in meters */
                    'atpress        =/* atmospheric pressure in mbar/hPa */
                    'attemp         =// atmospheric temperature in degrees Celsius
                    'lapse_rate     =/* (dattemp/dgeoalt) = [K/m] */
                    'calc_flag      =/* Flag for Calculation. See user's manual */
                    'dret           =/* result: Return array, See User's manual */Declare array of 50 doubles
                    '<RETURN>: Double


'[80]_swe_revjul@28{swe_revjul}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  786]:     ext_def(void) swe_revjul(double jd,int gregflag,int *jyear, int *jmon, int *jday, double *jut);
'9.         Date and time conversion functions
'9.1.  Calendar date and Julian day: swe_julday(), swe_date_conversion(), /swe_revjul()
' It computes year, month, day and hour from a Julian day number.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_revjul Lib "swedll32.dll" _
                    Alias "_swe_revjul@28" ( _
                      ByVal jd As Double, _
                      ByVal gregflag As Long, _
                      ByRef jyear As Long, _
                      ByRef jmon As Long, _
                      ByRef jday As Long, _
                      ByRef jut As Double _
                    ) 'No return
                    'jd             =//Julian Day Number
                    'gregflag       =/*calendars Flag for Calculation.See User's manual */
                    'jyear          =//Year of the Julianday Number
                    'jmon           =//month of the Julianday Number
                    'jday           =//Day of the Julianday Number
                    'jut            =//Julianday UT Hours
                    '<RETURN>: Nil


'[81]_swe_rise_trans@52{swe_rise_trans}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  923]:     ext_def(int32) swe_rise_trans(double tjd_ut, int32 ipl, char *starname, int32 epheflag, int32 rsmi,double *geopos, double atpress, double attemp,double *tret,char *serr);
'8.12.      swe_rise_trans() and swe_rise_trans_true_hor() (risings, settings, meridian transits)
'The function computes the times of rising, setting and meridian transits for
'all planets, asteroids, the moon, and the fixed stars.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_rise_trans Lib "swedll32.dll" _
                    Alias "_swe_rise_trans@52" ( _
                      ByVal tjd_ut As Double, _
                      ByVal ipl As Long, _
                      ByVal starname As String, _
                      ByVal epheflag As Long, _
                      ByVal rsmi As Long, _
                      ByRef geopos As Double, _
                      ByVal atpress As Double, _
                      ByVal attemp As Double, _
                      ByRef tret As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'ipl            =//fixed set of body numbers
                    'starname       =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'epheflag       =/* ephemeris flag */
                    'rsmi           =/* integer specifying that rise, set, or one of the two meridian transits is wanted. see definition User's manual */
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'atpress        =/* atmospheric pressure in mbar/hPa */
                    'attemp         =// atmospheric temperature in degrees Celsius
                    'tret           =//Time details /* return array, Array of 10 doubles, see User's manual */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[82]_swe_rise_trans_true_hor@60{swe_rise_trans_true_hor}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  914]:     ext_def(int32) swe_rise_trans_true_hor(double tjd_ut, int32 ipl, char *starname, int32 epheflag, int32 rsmi,double *geopos, double atpress, double attemp, double horhgt,double *tret,char *serr);
'8.12.      swe_rise_trans() and swe_rise_trans_true_hor() (risings, settings, meridian transits)
'The function computes the times of rising, setting and meridian transits for
'all planets, asteroids, the moon, and the fixed stars for a local horizon that has an altitude != 0
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_rise_trans_true_hor Lib "swedll32.dll" _
                    Alias "_swe_rise_trans_true_hor@60" ( _
                      ByVal tjd_ut As Double, _
                      ByVal ipl As Long, _
                      ByVal starname As String, _
                      ByVal epheflag As Long, _
                      ByVal rsmi As Long, _
                      ByRef geopos As Double, _
                      ByVal atpress As Double, _
                      ByVal attemp As Double, _
                      ByVal horhgt As Double, _
                      ByRef tret As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_ut         =//Julian day, universal time (UT)
                    'ipl            =//fixed set of body numbers
                    'starname       =//name of fixed star to be searched, returned name of found star/Declare to hold 256 Chars
                    'epheflag       =/* ephemeris flag */
                    'rsmi           =/* integer specifying that rise, set, or one of the two meridian transits is wanted. see definition User's manual */
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'atpress        =/* atmospheric pressure in mbar/hPa */
                    'attemp         =// atmospheric temperature in degrees Celsius
                    'horhgt         =/* height of local horizon in deg at the point where the body rises or sets*/
                    'tret           =//Time details /* return array, Array of 10 doubles, see User's manual */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[83]_swe_set_astro_models@8{swe_set_astro_models}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  691]:     ext_def(void) swe_set_astro_models(char *samod, int32 iflag);
'***********************(obsolete/Internal use)*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_set_astro_models Lib "swedll32.dll" _
                    Alias "_swe_set_astro_models@8" ( _
                      ByVal samod As String, _
                      ByVal iflag As Long _
                    ) 'No return
                    'samod          =//Model Name for internal use only
                    'iflag          =//Control Flag for internal use only
                    '<RETURN>: Nil


'[84]_swe_set_delta_t_userdef@8{swe_set_delta_t_userdef}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  975]:     ext_def(void) swe_set_delta_t_userdef(double dt);
'10.4.      swe_set_delta_t_userdef()
'This function allows the user to set a fixed DeltaT value that will be
'returned by swe_deltat() or swe_deltat_ex().
'The same Delta T value will then be used by swe_calc_ut(), eclipse functions,
'heliacal functions, and all functions that require UT as input time.
'In order to return to automatic Delta T, call this function with the
'following value swe_set_delta_t_userdef(SE_DELTAT_AUTOMATIC)
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_set_delta_t_userdef Lib "swedll32.dll" _
                    Alias "_swe_set_delta_t_userdef@8" ( _
                      ByVal dt As Double _
                    ) 'No return
                    'dt             =//Delt_T user Defined Value
                    '<RETURN>: Nil


'[85]_swe_set_ephe_path@4{swe_set_ephe_path}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  746]:     ext_def(void) swe_set_ephe_path(char *path);
'2.         The Ephemeris file related functions
'2.1.  swe_set_ephe_path()
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_set_ephe_path Lib "swedll32.dll" _
                    Alias "_swe_set_ephe_path@4" ( _
                      ByVal path As String _
                    ) 'No return
                    'path           =//Set String  must be able to hold Required Size
                    '<RETURN>: Nil


'[86]_swe_set_interpolate_nut@4{swe_set_interpolate_nut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  963]:     ext_def(void) swe_set_interpolate_nut(AS_BOOL do_interpolate);
'***********************(obsolete/Internal use)*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_set_interpolate_nut Lib "swedll32.dll" _
                    Alias "_swe_set_interpolate_nut@4" ( _
                      ByVal do_interpolate As Long _
                    ) 'No return
                    'do_interpolate =//For internal use
                    '<RETURN>: Nil


'[87]_swe_set_jpl_file@4{swe_set_jpl_file}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  749]:     ext_def(void) swe_set_jpl_file(char *fname);
'2.         The Ephemeris file related functions
'2.3.  swe_set_jpl_file()
'/* set name of JPL ephemeris file */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_set_jpl_file Lib "swedll32.dll" _
                    Alias "_swe_set_jpl_file@4" ( _
                      ByVal fname As String _
                    ) 'No return
                    'fname          =//String  must be able to hold 256 bytes
                    '<RETURN>: Nil


'[88]_swe_set_lapse_rate@8{swe_set_lapse_rate}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  896]:     ext_def(void) swe_set_lapse_rate(double lapse_rate);
'*WARNING:/* This function may be for inhouse testing only */*******
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_set_lapse_rate Lib "swedll32.dll" _
                    Alias "_swe_set_lapse_rate@8" ( _
                      ByVal lapse_rate As Double _
                    ) 'No return
                    'lapse_rate     =//Value internal use
                    '<RETURN>: Nil


'[89]_swe_set_sid_mode@20{swe_set_sid_mode}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  758]:     ext_def(void) swe_set_sid_mode(int32 sid_mode, double t0, double ayan_t0);
'12.     Sidereal mode functions
'12.1.      swe_set_sid_mode()
'This function can be used to specify the mode for sidereal computations.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_set_sid_mode Lib "swedll32.dll" _
                    Alias "_swe_set_sid_mode@20" ( _
                      ByVal sid_mode As Long, _
                      ByVal t0 As Double, _
                      ByVal ayan_t0 As Double _
                    ) 'No return
                    'sid_mode       =//Flag for sid. mode calculation, Ayanamsa etc.,
                    't0             =//Julianday number t0 for ayan_t0
                    'ayan_t0        =//initial value of the ayanamsha (ayan_t0) user defined case
                    '<RETURN>: Nil


'[90]_swe_set_tid_acc@8{swe_set_tid_acc}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  971]:     ext_def(void) swe_set_tid_acc(double t_acc);
'10.3.      swe_set_tid_acc(), swe_get_tid_acc()
'to set a different acceleration value.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_set_tid_acc Lib "swedll32.dll" _
                    Alias "_swe_set_tid_acc@8" ( _
                      ByVal t_acc As Double _
                    ) 'No return
                    't_acc          =//tidal acceleration Value
                    '<RETURN>: Nil


'[91]_swe_set_topo@24{swe_set_topo}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  755]:     ext_def(void) swe_set_topo(double geolon, double geolat, double geoalt);
'11.     The function swe_set_topo() for topocentric planet positions
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_set_topo Lib "swedll32.dll" _
                    Alias "_swe_set_topo@24" ( _
                      ByVal geolon As Double, _
                      ByVal geolat As Double, _
                      ByVal geoalt As Double _
                    ) 'No return
                    'geolon         =// geographic longitude,East is positive & West is negative
                    'geolat         =// latitude,northern is positive & southern is negative
                    'geoalt         =/* altitude of observer above sea level in meters */
                    '<RETURN>: Nil


'[92]_swe_sidtime0@24{swe_sidtime0}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  961]:     ext_def(double) swe_sidtime0(double tjd_ut, double eps, double nut);
'17.     Sidereal time with swe_sidtime() and swe_sidtime0()
'Use this function to calculate sidereal time separately.
'It requires obliquity and nutation to be given in the function call
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_sidtime0 Lib "swedll32.dll" _
                    Alias "_swe_sidtime0@24" ( _
                      ByVal tjd_ut As Double, _
                      ByVal eps As Double, _
                      ByVal nut As Double _
                    ) As Double
                    'tjd_ut         =//Julian day, universal time (UT)
                    'eps            =//Obliquity of ecliptic, in Decimal degrees
                    'nut            =/* nutation in longitude, in degrees */
                    '<RETURN>: Double


'[93]_swe_sidtime@8{swe_sidtime}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  962]:     ext_def(double) swe_sidtime(double tjd_ut);
'17.     Sidereal time with swe_sidtime() and swe_sidtime0()
'Gives sidereal time at the Greenwich Meridian, measured in hours
'Use this function to calculate sidereal time separately.
'obliquity and nutation are calculated internally.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_sidtime Lib "swedll32.dll" _
                    Alias "_swe_sidtime@8" ( _
                      ByVal tjd_ut As Double _
                    ) As Double
                    'tjd_ut         =//Julian day, universal time (UT)
                    '<RETURN>: Double


'[94]_swe_sol_eclipse_how@24{swe_sol_eclipse_how}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  857]:     ext_def(int32) swe_sol_eclipse_how(double tjd, int32 ifl, double *geopos, double *attr, char *serr);
'8.4.  swe_sol_eclipse_how ()
'To calculate the attributes of an eclipse for a given geographic position and time:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_sol_eclipse_how Lib "swedll32.dll" _
                    Alias "_swe_sol_eclipse_how@24" ( _
                      ByVal tjd As Double, _
                      ByVal ifl As Long, _
                      ByRef geopos As Double, _
                      ByRef attr As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd            =//Julian Day Number
                    'ifl            =/* ephemeris Flag for Calculation. See user's manual */
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'attr           =/* return array of 20 doubles, see user's manual*/
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[95]_swe_sol_eclipse_when_glob@28{swe_sol_eclipse_when_glob}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  866]:     ext_def(int32) swe_sol_eclipse_when_glob(double tjd_start, int32 ifl, int32 ifltype,double *tret, int32 backward, char *serr);
'8.3.  swe_sol_eclipse_when_glob()
'To find the next eclipse globally:
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_sol_eclipse_when_glob Lib "swedll32.dll" _
                    Alias "_swe_sol_eclipse_when_glob@28" ( _
                      ByVal tjd_start As Double, _
                      ByVal ifl As Long, _
                      ByVal ifltype As Long, _
                      ByRef tret As Double, _
                      ByVal backward As Long, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_start      =/* start date for search, Jul. day UT */
                    'ifl            =/* ephemeris Flag for Calculation. See user's manual */
                    'ifltype        =/* Flag for Calculation. See user's manual */
                    'tret           =//Time details /* return array, Array of 10 doubles, see User's manual */
                    'backward       =/* TRUE, if backward search */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[96]_swe_sol_eclipse_when_loc@32{swe_sol_eclipse_when_loc}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  860]:     ext_def(int32) swe_sol_eclipse_when_loc(double tjd_start, int32 ifl, double *geopos, double *tret, double *attr, int32 backward, char *serr);
'8.         Eclipses, risings, settings, meridian transits, planetary phenomena
'finds the next eclipse for a given geographic position
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_sol_eclipse_when_loc Lib "swedll32.dll" _
                    Alias "_swe_sol_eclipse_when_loc@32" ( _
                      ByVal tjd_start As Double, _
                      ByVal ifl As Long, _
                      ByRef geopos As Double, _
                      ByRef tret As Double, _
                      ByRef attr As Double, _
                      ByVal backward As Long, _
                      ByVal serr As String _
                    ) As Long
                    'tjd_start      =/* start date for search, Jul. day UT */
                    'ifl            =/* ephemeris Flag for Calculation. See user's manual */
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'tret           =//Time details /* return array, Array of 10 doubles, see User's manual */
                    'attr           =/* return array of 20 doubles, see user's manual*/
                    'backward       =/* TRUE, if backward search */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[97]_swe_sol_eclipse_where@24{swe_sol_eclipse_where}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  852]:     ext_def(int32) swe_sol_eclipse_where(double tjd, int32 ifl, double *geopos, double *attr, char *serr);
'8.5.  swe_sol_eclipse_where ()
'This function can be used to find out the geographic position, where,
'for a given time, a central eclipse is central or
'where a non-central eclipse is maximal.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_sol_eclipse_where Lib "swedll32.dll" _
                    Alias "_swe_sol_eclipse_where@24" ( _
                      ByVal tjd As Double, _
                      ByVal ifl As Long, _
                      ByRef geopos As Double, _
                      ByRef attr As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd            =//Julian Day Number
                    'ifl            =/* ephemeris Flag for Calculation. See user's manual */
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'attr           =/* return array of 20 doubles, see user's manual*/
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[98]_swe_solcross@24{swe_solcross}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  712]:     ext_def(double) swe_solcross(double x2cross, double jd_et, int32 flag, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Sun over a given ecliptic position:
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_solcross Lib "swedll32.dll" _
                    Alias "_swe_solcross@24" ( _
                      ByVal x2cross As Double, _
                      ByVal jd_et As Double, _
                      ByVal flag As Long, _
                      ByVal serr As String _
                    ) As Double
                    'x2cross        =//heliocentric crossings over a position x2cross
                    'jd_et          =//Julian day, Ephemeris time/TT
                    'flag           =/* Flag for Calculation. See user's manual */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Double


'[99]_swe_solcross_ut@24{swe_solcross_ut}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  713]:     ext_def(double) swe_solcross_ut(double x2cross, double jd_ut, int32 flag, char *serr);
'4.         Functions to find crossings of planets over positions
'These functions find the crossing of the Sun over a given ecliptic position:
'***********************<>*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_solcross_ut Lib "swedll32.dll" _
                    Alias "_swe_solcross_ut@24" ( _
                      ByVal x2cross As Double, _
                      ByVal jd_ut As Double, _
                      ByVal flag As Long, _
                      ByVal serr As String _
                    ) As Double
                    'x2cross        =//heliocentric crossings over a position x2cross
                    'jd_ut          =//Julian day, universal time (UT)
                    'flag           =/* Flag for Calculation. See user's manual */
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Double


'[100]_swe_split_deg@32{swe_split_deg}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  982]:     ext_def(void) swe_split_deg(double ddeg, int32 roundflag, int32 *ideg, int32 *imin, int32 *isec, double *dsecfr, int32 *isgn);
'18.6.6.      swe_split_deg(): split degrees to sign/nakshatra, degrees, minutes, seconds of arc
'This function takes a decimal degree number as input and provides
'sign or nakshatra, degree, minutes, seconds and fraction of second.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_split_deg Lib "swedll32.dll" _
                    Alias "_swe_split_deg@32" ( _
                      ByVal ddeg As Double, _
                      ByVal roundflag As Long, _
                      ByRef ideg As Long, _
                      ByRef imin As Long, _
                      ByRef isec As Long, _
                      ByRef dsecfr As Double, _
                      ByRef isgn As Long _
                    ) 'No return
                    'ddeg           =//decimal degrees, ecliptic longitude
                    'roundflag      =/* Flag for rounding Calculation.See user's manual*/
                    'ideg           =//Integer part of Decimal Degree
                    'imin           =//Integer minute part of  Decimal hour
                    'isec           =//Integer Seconds part of  Decimal hour
                    'dsecfr         =//fraction of seconds
                    'isgn           =//sign or nakshatra Details
                    '<RETURN>: Nil


'[101]_swe_time_equ@16{swe_time_equ}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  956]:     ext_def(int32) swe_time_equ(double tjd, double *te, char *serr);
'9.4.  Mean solar time versus True solar time: swe_time_equ(), swe_lmt_to_lat(), swe_lat_to_lmt()
'Equation of Time: e = (LAT - LMT)
'returns the difference between local apparent and local mean time
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_time_equ Lib "swedll32.dll" _
                    Alias "_swe_time_equ@16" ( _
                      ByVal tjd As Double, _
                      ByRef te As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjd            =//Julian Day Number
                    'te             =//Equation of time value
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[102]_swe_topo_arcus_visionis@80{swe_topo_arcus_visionis}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  687]:     ext_def(int32) swe_topo_arcus_visionis(double tjdut, double *dgeo, double *datm, double *dobs, int32 helflag, double mag, double azi_obj, double alt_obj, double azi_sun, double azi_moon, double alt_moon, double *dret, char *serr);
'***********************(obsolete/Internal use)*******************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_topo_arcus_visionis Lib "swedll32.dll" _
                    Alias "_swe_topo_arcus_visionis@80" ( _
                      ByVal tjdut As Double, _
                      ByRef dgeo As Double, _
                      ByRef datm As Double, _
                      ByRef dobs As Double, _
                      ByVal helflag As Long, _
                      ByVal mag As Double, _
                      ByVal azi_obj As Double, _
                      ByVal alt_obj As Double, _
                      ByVal azi_sun As Double, _
                      ByVal azi_moon As Double, _
                      ByVal alt_moon As Double, _
                      ByRef dret As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjdut          =//Julian day, universal time (UT)
                    'dgeo           =/* geographic position (details User's manual) */declare array of 3 doubles
                    'datm           =/* atmospheric conditions (details User's manual) */declare array of 10 doubles
                    'dobs           =/* observer description (details User's manual) */declare array of 10 doubles
                    'helflag        =/* Flag for Calculation. See user's manual */
                    'mag            =//For internal use
                    'azi_obj        =//For internal use
                    'alt_obj        =//For internal use
                    'azi_sun        =//For internal use
                    'azi_moon       =//For internal use
                    'alt_moon       =//For internal use
                    'dret           =/* result: Return array, See User's manual */Declare array of 50 doubles
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[103]_swe_utc_time_zone@60{swe_utc_time_zone}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  806]:     ext_def(void) swe_utc_time_zone(int32 iyear, int32 imonth, int32 iday, int32 ihour, int32 imin, double dsec, double d_timezone, int32 *iyear_out, int32 *imonth_out, int32 *iday_out, int32 *ihour_out, int32 *imin_out, double *dsec_out);
'9.2.  UTC and Julian day: swe_utc_time_zone(), swe_utc_to_jd(), swe_jdet_to_utc(), swe_jdut1_to_utc()
'converts UTC int local time zone time.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Sub swe_utc_time_zone Lib "swedll32.dll" _
                    Alias "_swe_utc_time_zone@60" ( _
                      ByVal iyear As Long, _
                      ByVal imonth As Long, _
                      ByVal iday As Long, _
                      ByVal ihour As Long, _
                      ByVal imin As Long, _
                      ByVal dsec As Double, _
                      ByVal d_timezone As Double, _
                      ByRef iyear_out As Long, _
                      ByRef imonth_out As Long, _
                      ByRef iday_out As Long, _
                      ByRef ihour_out As Long, _
                      ByRef imin_out As Long, _
                      ByRef dsec_out As Double _
                    ) 'No return
                    'iyear          =//Year of the date
                    'imonth         =//Month of the date
                    'iday           =//Day in the date
                    'ihour          =//Hour part of the time
                    'imin           =//minute part of the time
                    'dsec           =//second is a decimal
                    'd_timezone     =//timezone offset, east of Greenwich is positive & west of Greenwich is negative
                    'iyear_out      =//Year in the date
                    'imonth_out     =//Month in the date
                    'iday_out       =//Day in the date
                    'ihour_out      =//Integer part of  Decimal hour
                    'imin_out       =//Integer minute part of  Decimal hour
                    'dsec_out       =//Decimal Seconds
                    '<RETURN>: Nil


'[104]_swe_utc_to_jd@40{swe_utc_to_jd}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  791]:     ext_def(int32) swe_utc_to_jd(int32 iyear, int32 imonth, int32 iday, int32 ihour, int32 imin, double dsec, int32 gregflag, double *dret, char *serr);
'9.2.  UTC and Julian day: swe_utc_time_zone(), swe_utc_to_jd(), swe_jdet_to_utc(), swe_jdut1_to_utc()
'18.3.6.      UTC to jd (TT and UT1)
'/* calculate Julian day number in UT (UT1) and ET (TT) from UTC */
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_utc_to_jd Lib "swedll32.dll" _
                    Alias "_swe_utc_to_jd@40" ( _
                      ByVal iyear As Long, _
                      ByVal imonth As Long, _
                      ByVal iday As Long, _
                      ByVal ihour As Long, _
                      ByVal imin As Long, _
                      ByVal dsec As Double, _
                      ByVal gregflag As Long, _
                      ByRef dret As Double, _
                      ByVal serr As String _
                    ) As Long
                    'iyear          =//Year of the date
                    'imonth         =//Month of the date
                    'iday           =//Day in the date
                    'ihour          =//Hour part of the time
                    'imin           =//minute part of the time
                    'dsec           =//second is a decimal
                    'gregflag       =/*calendars Flag for Calculation.See User's manual */
                    'dret           =/* result: Return array, See User's manual */Declare array of 50 doubles
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'[105]_swe_version@4{swe_version_LPCHARA}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  698]:     ext_def(char *) swe_version(char *);
'2.4.  swe_version()
'/* find out version number of your Swiss Ephemeris version */
'returns the version of the Swiss Ephemeris
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_version_LPCHARA Lib "swedll32.dll" _
                    Alias "_swe_version@4" ( _
                      ByVal s As String _
                    ) As Long
                    's              =//Return String  must be able to hold 256 bytes
                    '<RETURN>: LongPointer to Array of Chars(String)


'[106]_swe_vis_limit_mag@36{swe_vis_limit_mag}
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'{H1}Line[  683]:     ext_def(int32) swe_vis_limit_mag(double tjdut, double *geopos, double *datm, double *dobs, char *ObjectName, int32 helflag, double *dret, char *serr);
'8.18.      Magnitude limit for visibility: swe_vis_limit_mag()
'This function determines the limiting visual magnitude in dark skies.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Public Declare Function swe_vis_limit_mag Lib "swedll32.dll" _
                    Alias "_swe_vis_limit_mag@36" ( _
                      ByVal tjdut As Double, _
                      ByRef geopos As Double, _
                      ByRef datm As Double, _
                      ByRef dobs As Double, _
                      ByVal ObjectName As String, _
                      ByVal helflag As Long, _
                      ByRef dret As Double, _
                      ByVal serr As String _
                    ) As Long
                    'tjdut          =//Julian day, universal time (UT)
                    'geopos         =/* array of 3 doubles containing geographic lon, lat, height*/
                    'datm           =/* atmospheric conditions (details User's manual) */declare array of 10 doubles
                    'dobs           =/* observer description (details User's manual) */declare array of 10 doubles
                    'ObjectName     =/* name string of fixed star or planet */ Name Size 40 Chars?
                    'helflag        =/* Flag for Calculation. See user's manual */
                    'dret           =/* result: Return array, See User's manual */Declare array of 50 doubles
                    'serr           =//Return Error String  must be able to hold 256 bytes
                    '<RETURN>: Long


'--------------------------------------------------------------------------------
'{H1}Total Exports VB API32 Declarations: 106
'################################################################################
'End of Exports VB API32 Declarations from Header File:swephexp.h
'################################################################################
'========================End of functions declarations===========================

'################################################################################
'Exports constants from Header File:*.H
'################################################################################
'================================================================================
'FileRef  : {H1}
'FileName : swephexp.h
'FileDate : 04/08/2021 17:11:51
'FileSize : 41939 Bytes
'--------------------------------------------------------------------------------
'/************************************************************
'  SWISSEPH: exported definitions and constants
'
'  swephexp.h file represents the standard application interface (API)
'  to the Swiss Ephemeris.
'
'
'  The function calls are documented in the Programmer's documentation,
'  which is online in HTML format.
'
'  Structure of this file:
'    Public API definitions
'    Internal developer's definitions
'    Public API functions.
'
'
'************************************************************/
'
'
'/***********************************************************
' * definitions for use also by non-C programmers
' ***********************************************************/
'
Public Const SE_AUNIT_TO_KM                  As Double = (149597870.7)
Public Const SE_AUNIT_TO_LIGHTYEAR           As Double = (1# / 63241.07708427)
Public Const SE_AUNIT_TO_PARSEC              As Double = (1# / 206264.8062471)
'
'/* values for gregflag in swe_julday() and swe_revjul() */
Public Const SE_JUL_CAL                      As Long = 0
Public Const SE_GREG_CAL                     As Long = 1
'
'/*
' * planet numbers for the ipl parameter in swe_calc()
' */
Public Const SE_ECL_NUT                      As Long = -1
'
Public Const SE_SUN                          As Long = 0
Public Const SE_MOON                         As Long = 1
Public Const SE_MERCURY                      As Long = 2
Public Const SE_VENUS                        As Long = 3
Public Const SE_MARS                         As Long = 4
Public Const SE_JUPITER                      As Long = 5
Public Const SE_SATURN                       As Long = 6
Public Const SE_URANUS                       As Long = 7
Public Const SE_NEPTUNE                      As Long = 8
Public Const SE_PLUTO                        As Long = 9
Public Const SE_MEAN_NODE                    As Long = 10
Public Const SE_TRUE_NODE                    As Long = 11
Public Const SE_MEAN_APOG                    As Long = 12
Public Const SE_OSCU_APOG                    As Long = 13
Public Const SE_EARTH                        As Long = 14
Public Const SE_CHIRON                       As Long = 15
Public Const SE_PHOLUS                       As Long = 16
Public Const SE_CERES                        As Long = 17
Public Const SE_PALLAS                       As Long = 18
Public Const SE_JUNO                         As Long = 19
Public Const SE_VESTA                        As Long = 20
Public Const SE_INTP_APOG                    As Long = 21
Public Const SE_INTP_PERG                    As Long = 22
'
Public Const SE_NPLANETS                     As Long = 23
'
Public Const SE_PLMOON_OFFSET                As Long = 9000
Public Const SE_AST_OFFSET                   As Long = 10000
Public Const SE_VARUNA                       As Long = (SE_AST_OFFSET + 20000)
'
Public Const SE_FICT_OFFSET                  As Long = 40
Public Const SE_FICT_OFFSET_1                As Long = 39
Public Const SE_FICT_MAX                     As Long = 999
Public Const SE_NFICT_ELEM                   As Long = 15
'
Public Const SE_COMET_OFFSET                 As Long = 1000
'
Public Const SE_NALL_NAT_POINTS              As Long = (SE_NPLANETS + SE_NFICT_ELEM)
'
'/* Hamburger or Uranian "planets" */
Public Const SE_CUPIDO                       As Long = 40
Public Const SE_HADES                        As Long = 41
Public Const SE_ZEUS                         As Long = 42
Public Const SE_KRONOS                       As Long = 43
Public Const SE_APOLLON                      As Long = 44
Public Const SE_ADMETOS                      As Long = 45
Public Const SE_VULKANUS                     As Long = 46
Public Const SE_POSEIDON                     As Long = 47
'/* other fictitious bodies */
Public Const SE_ISIS                         As Long = 48
Public Const SE_NIBIRU                       As Long = 49
Public Const SE_HARRINGTON                   As Long = 50
Public Const SE_NEPTUNE_LEVERRIER            As Long = 51
Public Const SE_NEPTUNE_ADAMS                As Long = 52
Public Const SE_PLUTO_LOWELL                 As Long = 53
Public Const SE_PLUTO_PICKERING              As Long = 54
Public Const SE_VULCAN                       As Long = 55
Public Const SE_WHITE_MOON                   As Long = 56
Public Const SE_PROSERPINA                   As Long = 57
Public Const SE_WALDEMATH                    As Long = 58
'
Public Const SE_FIXSTAR                      As Long = -10
'
Public Const SE_ASC                          As Long = 0
Public Const SE_MC                           As Long = 1
Public Const SE_ARMC                         As Long = 2
Public Const SE_VERTEX                       As Long = 3
Public Const SE_EQUASC                       As Long = 4    '   /* "equatorial ascendant" */
Public Const SE_COASC1                       As Long = 5    '   /* "co-ascendant" (W. Koch) */
Public Const SE_COASC2                       As Long = 6    '   /* "co-ascendant" (M. Munkasey) */
Public Const SE_POLASC                       As Long = 7    '   /* "polar ascendant" (M. Munkasey) */
Public Const SE_NASCMC                       As Long = 8
'
'/*
' * flag bits for parameter iflag in function swe_calc()
' * The flag bits are defined in such a way that iflag = 0 delivers what one
' * usually wants:
' *    - the default ephemeris (SWISS EPHEMERIS) is used,
' *    - apparent geocentric positions referring to the true equinox of date
' *      are returned.
' * If not only coordinates, but also speed values are required, use
' * flag = SEFLG_SPEED.
' *
' * The 'L' behind the number indicates that 32-bit integers (Long) are used.
' */
Public Const SEFLG_JPLEPH                    As Long = 1 '/* use JPL ephemeris */
Public Const SEFLG_SWIEPH                    As Long = 2 '/* use SWISSEPH ephemeris */
Public Const SEFLG_MOSEPH                    As Long = 4 '/* use Moshier ephemeris */
'
Public Const SEFLG_HELCTR                    As Long = 8 '/* heliocentric position */
Public Const SEFLG_TRUEPOS                   As Long = 16 '/* true/geometric position, not apparent position */
Public Const SEFLG_J2000                     As Long = 32 '/* no precession, i.e. give J2000 equinox */
Public Const SEFLG_NONUT                     As Long = 64 '/* no nutation, i.e. mean equinox of date */
Public Const SEFLG_SPEED3                    As Long = 128 '/* speed from 3 positions (do not use it,
'                                * SEFLG_SPEED is faster and more precise.) */
Public Const SEFLG_SPEED                     As Long = 256 '/* high precision speed  */
Public Const SEFLG_NOGDEFL                   As Long = 512 '/* turn off gravitational deflection */
Public Const SEFLG_NOABERR                   As Long = 1024 '/* turn off 'annual' aberration of light */
Public Const SEFLG_ASTROMETRIC               As Long = (SEFLG_NOABERR Or SEFLG_NOGDEFL) ' /* astrometric position,
'                                * i.e. with light-time, but without aberration and
'                   * light deflection */
Public Const SEFLG_EQUATORIAL                As Long = (2& * 1024) '    /* equatorial positions are wanted */
Public Const SEFLG_XYZ                       As Long = (4& * 1024) '     /* cartesian, not polar, coordinates */
Public Const SEFLG_RADIANS                   As Long = (8& * 1024) '     /* coordinates in radians, not degrees */
Public Const SEFLG_BARYCTR                   As Long = (16& * 1024) '    /* barycentric position */
Public Const SEFLG_TOPOCTR                   As Long = (32& * 1024) '    /* topocentric position */
Public Const SEFLG_ORBEL_AA                  As Long = SEFLG_TOPOCTR '/* used for Astronomical Almanac mode in
'                                      * calculation of Kepler elipses */
Public Const SEFLG_TROPICAL                  As Long = (0) '          /* tropical position (default) */
Public Const SEFLG_SIDEREAL                  As Long = (64& * 1024) '    /* sidereal position */
Public Const SEFLG_ICRS                      As Long = (128& * 1024) '   /* ICRS (DE406 reference frame) */
Public Const SEFLG_DPSIDEPS_1980             As Long = (256& * 1024) ' /* reproduce JPL Horizons
'                                      * 1962 - today to 0.002 arcsec. */
Public Const SEFLG_JPLHOR                    As Long = SEFLG_DPSIDEPS_1980
Public Const SEFLG_JPLHOR_APPROX             As Long = (512& * 1024) '   /* approximate JPL Horizons 1962 - today */
Public Const SEFLG_CENTER_BODY               As Long = (1024& * 1024) '  /* calculate position of center of body (COB)
'                                                of planet, not barycenter of its system */
Public Const SEFLG_TEST_PLMOON               As Long = (2& * 1024& * 1024 Or SEFLG_J2000 Or SEFLG_ICRS Or SEFLG_HELCTR Or SEFLG_TRUEPOS)    '  /* test raw data in files sepm9* */
'
'
Public Const SE_SIDBITS                      As Long = 256
'/* for projection onto ecliptic of t0 */
Public Const SE_SIDBIT_ECL_T0                As Long = 256
'/* for projection onto solar system plane */
Public Const SE_SIDBIT_SSY_PLANE             As Long = 512
'/* with user-defined ayanamsha, t0 is UT */
Public Const SE_SIDBIT_USER_UT               As Long = 1024
'/* ayanamsha measured on ecliptic of date;
' * see commentaries in sweph.c:swi_get_ayanamsa_ex(). */
Public Const SE_SIDBIT_ECL_DATE              As Long = 2048
'/* test feature: don't apply constant offset to ayanamsha
' * see commentary above sweph.c:get_aya_correction() */
Public Const SE_SIDBIT_NO_PREC_OFFSET        As Long = 4096
'/* test feature: calculate ayanamsha using its original precession model */
Public Const SE_SIDBIT_PREC_ORIG             As Long = 8192
'
'/* sidereal modes (ayanamsas) */
Public Const SE_SIDM_FAGAN_BRADLEY           As Long = 0
Public Const SE_SIDM_LAHIRI                  As Long = 1
Public Const SE_SIDM_DELUCE                  As Long = 2
Public Const SE_SIDM_RAMAN                   As Long = 3
Public Const SE_SIDM_USHASHASHI              As Long = 4
Public Const SE_SIDM_KRISHNAMURTI            As Long = 5
Public Const SE_SIDM_DJWHAL_KHUL             As Long = 6
Public Const SE_SIDM_YUKTESHWAR              As Long = 7
Public Const SE_SIDM_JN_BHASIN               As Long = 8
Public Const SE_SIDM_BABYL_KUGLER1           As Long = 9
Public Const SE_SIDM_BABYL_KUGLER2           As Long = 10
Public Const SE_SIDM_BABYL_KUGLER3           As Long = 11
Public Const SE_SIDM_BABYL_HUBER             As Long = 12
Public Const SE_SIDM_BABYL_ETPSC             As Long = 13
Public Const SE_SIDM_ALDEBARAN_15TAU         As Long = 14
Public Const SE_SIDM_HIPPARCHOS              As Long = 15
Public Const SE_SIDM_SASSANIAN               As Long = 16
Public Const SE_SIDM_GALCENT_0SAG            As Long = 17
Public Const SE_SIDM_J2000                   As Long = 18
Public Const SE_SIDM_J1900                   As Long = 19
Public Const SE_SIDM_B1950                   As Long = 20
Public Const SE_SIDM_SURYASIDDHANTA          As Long = 21
Public Const SE_SIDM_SURYASIDDHANTA_MSUN     As Long = 22
Public Const SE_SIDM_ARYABHATA               As Long = 23
Public Const SE_SIDM_ARYABHATA_MSUN          As Long = 24
Public Const SE_SIDM_SS_REVATI               As Long = 25
Public Const SE_SIDM_SS_CITRA                As Long = 26
Public Const SE_SIDM_TRUE_CITRA              As Long = 27
Public Const SE_SIDM_TRUE_REVATI             As Long = 28
Public Const SE_SIDM_TRUE_PUSHYA             As Long = 29
Public Const SE_SIDM_GALCENT_RGILBRAND       As Long = 30
Public Const SE_SIDM_GALEQU_IAU1958          As Long = 31
Public Const SE_SIDM_GALEQU_TRUE             As Long = 32
Public Const SE_SIDM_GALEQU_MULA             As Long = 33
Public Const SE_SIDM_GALALIGN_MARDYKS        As Long = 34
Public Const SE_SIDM_TRUE_MULA               As Long = 35
Public Const SE_SIDM_GALCENT_MULA_WILHELM    As Long = 36
Public Const SE_SIDM_ARYABHATA_522           As Long = 37
Public Const SE_SIDM_BABYL_BRITTON           As Long = 38
Public Const SE_SIDM_TRUE_SHEORAN            As Long = 39
Public Const SE_SIDM_GALCENT_COCHRANE        As Long = 40
Public Const SE_SIDM_GALEQU_FIORENZA         As Long = 41
Public Const SE_SIDM_VALENS_MOON             As Long = 42
Public Const SE_SIDM_LAHIRI_1940             As Long = 43
Public Const SE_SIDM_LAHIRI_VP285            As Long = 44
Public Const SE_SIDM_KRISHNAMURTI_VP291      As Long = 45
Public Const SE_SIDM_LAHIRI_ICRC             As Long = 46
'//#define SE_SIDM_MANJULA         43
Public Const SE_SIDM_USER                    As Long = 255 '/* user-defined ayanamsha, t0 is TT */
'
Public Const SE_NSIDM_PREDEF                 As Long = 47
'
'/* used for swe_nod_aps(): */
Public Const SE_NODBIT_MEAN                  As Long = 1 '/* mean nodes/apsides */
Public Const SE_NODBIT_OSCU                  As Long = 2 '/* osculating nodes/apsides */
Public Const SE_NODBIT_OSCU_BAR              As Long = 4 '/* same, but motion about solar system barycenter is considered */
Public Const SE_NODBIT_FOPOINT               As Long = 256 '/* focal point of orbit instead of aphelion */
'
'/* default ephemeris used when no ephemeris flagbit is set */
Public Const SEFLG_DEFAULTEPH                As Long = SEFLG_SWIEPH
'
Public Const SE_MAX_STNAME                   As Long = 256  '   /* maximum size of fixstar name;
'                                                                * the parameter star in swe_fixstar
'                                                                * must allow twice this space for
'                                                                * the returned star name.
'                                                               */
'
'/* defines for eclipse computations */
'
Public Const SE_ECL_CENTRAL                  As Long = 1
Public Const SE_ECL_NONCENTRAL               As Long = 2
Public Const SE_ECL_TOTAL                    As Long = 4
Public Const SE_ECL_ANNULAR                  As Long = 8
Public Const SE_ECL_PARTIAL                  As Long = 16
Public Const SE_ECL_ANNULAR_TOTAL            As Long = 32
Public Const SE_ECL_HYBRID                   As Long = 32 '// = annular-total
Public Const SE_ECL_PENUMBRAL                As Long = 64
Public Const SE_ECL_ALLTYPES_SOLAR           As Long = (SE_ECL_CENTRAL Or SE_ECL_NONCENTRAL Or SE_ECL_TOTAL Or SE_ECL_ANNULAR Or SE_ECL_PARTIAL Or SE_ECL_ANNULAR_TOTAL)
Public Const SE_ECL_ALLTYPES_LUNAR           As Long = (SE_ECL_TOTAL Or SE_ECL_PARTIAL Or SE_ECL_PENUMBRAL)
Public Const SE_ECL_VISIBLE                  As Long = 128
Public Const SE_ECL_MAX_VISIBLE              As Long = 256
Public Const SE_ECL_1ST_VISIBLE              As Long = 512  '   /* begin of partial eclipse */
Public Const SE_ECL_PARTBEG_VISIBLE          As Long = 512  '   /* begin of partial eclipse */
Public Const SE_ECL_2ND_VISIBLE              As Long = 1024 '   /* begin of total eclipse */
Public Const SE_ECL_TOTBEG_VISIBLE           As Long = 1024 '   /* begin of total eclipse */
Public Const SE_ECL_3RD_VISIBLE              As Long = 2048 '/* end of total eclipse */
Public Const SE_ECL_TOTEND_VISIBLE           As Long = 2048 '/* end of total eclipse */
Public Const SE_ECL_4TH_VISIBLE              As Long = 4096 '/* end of partial eclipse */
Public Const SE_ECL_PARTEND_VISIBLE          As Long = 4096 '/* end of partial eclipse */
Public Const SE_ECL_PENUMBBEG_VISIBLE        As Long = 8192 '/* begin of penumbral eclipse */
Public Const SE_ECL_PENUMBEND_VISIBLE        As Long = 16384 '/* end of penumbral eclipse */
Public Const SE_ECL_OCC_BEG_DAYLIGHT         As Long = 8192 '/* occultation begins during the day */
Public Const SE_ECL_OCC_END_DAYLIGHT         As Long = 16384 '/* occultation ends during the day */
Public Const SE_ECL_ONE_TRY                  As Long = (32& * 1024)
'       /* check if the next conjunction of the moon with
'        * a planet is an occultation; don't search further */
'
'/* for swe_rise_transit() */
Public Const SE_CALC_RISE                    As Long = 1
Public Const SE_CALC_SET                     As Long = 2
Public Const SE_CALC_MTRANSIT                As Long = 4
Public Const SE_CALC_ITRANSIT                As Long = 8
Public Const SE_BIT_DISC_CENTER              As Long = 256 '/* to be or'ed to SE_CALC_RISE/SET,
'                    * if rise or set of disc center is
'                    * required */
Public Const SE_BIT_DISC_BOTTOM              As Long = 8192 '/* to be or'ed to SE_CALC_RISE/SET,
'                                      * if rise or set of lower limb of
'                     * disc is requried */
Public Const SE_BIT_GEOCTR_NO_ECL_LAT        As Long = 128 '/* use geocentric rather than topocentric
'                                        position of object and
'                   ignore its ecliptic latitude */
Public Const SE_BIT_NO_REFRACTION            As Long = 512 '/* to be or'ed to SE_CALC_RISE/SET,
'                    * if refraction is to be ignored */
Public Const SE_BIT_CIVIL_TWILIGHT           As Long = 1024 '/* to be or'ed to SE_CALC_RISE/SET */
Public Const SE_BIT_NAUTIC_TWILIGHT          As Long = 2048 '/* to be or'ed to SE_CALC_RISE/SET */
Public Const SE_BIT_ASTRO_TWILIGHT           As Long = 4096 '/* to be or'ed to SE_CALC_RISE/SET */
Public Const SE_BIT_FIXED_DISC_SIZE          As Long = 16384 '/* or'ed to SE_CALC_RISE/SET:
'                                     * neglect the effect of distance on
'                    * disc size */
Public Const SE_BIT_FORCE_SLOW_METHOD        As Long = 32768 '/* This is only an Astrodienst in-house
'                                                               * test flag. It forces the usage
'                                                               * of the old, slow calculation of
'                                                               * risings and settings. */
Public Const SE_BIT_HINDU_RISING             As Long = (SE_BIT_DISC_CENTER Or SE_BIT_NO_REFRACTION Or SE_BIT_GEOCTR_NO_ECL_LAT)
'
'/* for swe_azalt() and swe_azalt_rev() */
Public Const SE_ECL2HOR                      As Long = 0
Public Const SE_EQU2HOR                      As Long = 1
Public Const SE_HOR2ECL                      As Long = 0
Public Const SE_HOR2EQU                      As Long = 1
'
'/* for swe_refrac() */
Public Const SE_TRUE_TO_APP                  As Long = 0
Public Const SE_APP_TO_TRUE                  As Long = 1
'
'/*
' * only used for experimenting with various JPL ephemeris files
' * which are available at Astrodienst's internal network
' */
Public Const SE_DE_NUMBER                    As Long = 431
Public Const SE_FNAME_DE200                  As String = "de200.eph"
Public Const SE_FNAME_DE403                  As String = "de403.eph"
Public Const SE_FNAME_DE404                  As String = "de404.eph"
Public Const SE_FNAME_DE405                  As String = "de405.eph"
Public Const SE_FNAME_DE406                  As String = "de406.eph"
Public Const SE_FNAME_DE431                  As String = "de431.eph"
Public Const SE_FNAME_DFT                    As String = SE_FNAME_DE431
Public Const SE_FNAME_DFT2                   As String = SE_FNAME_DE406
Public Const SE_STARFILE_OLD                 As String = "fixstars.cat"
Public Const SE_STARFILE                     As String = "sefstars.txt"
Public Const SE_ASTNAMFILE                   As String = "seasnam.txt"
Public Const SE_FICTFILE                     As String = "seorbel.txt"
'
'/*
' * ephemeris path
' * this defines where ephemeris files are expected if the function
' * swe_set_ephe_path() is not called by the application.
' * Normally, every application should make this call to define its
' * own place for the ephemeris files.
' */
'
'#ifndef SE_EPHE_PATH
Public Const SE_EPHE_PATH                    As String = "\sweph\ephe\"
'#endif  /* SE_EPHE_PATH */
'
'/* defines for function swe_split_deg() (in swephlib.c) */
Public Const SE_SPLIT_DEG_ROUND_SEC          As Long = 1
Public Const SE_SPLIT_DEG_ROUND_MIN          As Long = 2
Public Const SE_SPLIT_DEG_ROUND_DEG          As Long = 4
Public Const SE_SPLIT_DEG_ZODIACAL           As Long = 8
Public Const SE_SPLIT_DEG_NAKSHATRA          As Long = 1024
Public Const SE_SPLIT_DEG_KEEP_SIGN          As Long = 16   '   /* don't round to next sign,
'                    * e.g. 29.9999999 will be rounded
'                    * to 29d59'59" (or 29d59' or 29d) */
Public Const SE_SPLIT_DEG_KEEP_DEG           As Long = 32   '   /* don't round to next degree
'                    * e.g. 13.9999999 will be rounded
'                    * to 13d59'59" (or 13d59' or 13d) */
'
'/* for heliacal functions */
Public Const SE_HELIACAL_RISING              As Long = 1
Public Const SE_HELIACAL_SETTING             As Long = 2
Public Const SE_MORNING_FIRST                As Long = SE_HELIACAL_RISING
Public Const SE_EVENING_LAST                 As Long = SE_HELIACAL_SETTING
Public Const SE_EVENING_FIRST                As Long = 3
Public Const SE_MORNING_LAST                 As Long = 4
Public Const SE_ACRONYCHAL_RISING            As Long = 5 '/* still not implemented */
Public Const SE_ACRONYCHAL_SETTING           As Long = 6 '/* still not implemented */
Public Const SE_COSMICAL_SETTING             As Long = SE_ACRONYCHAL_SETTING
'
Public Const SE_HELFLAG_LONG_SEARCH          As Long = 128
Public Const SE_HELFLAG_HIGH_PRECISION       As Long = 256
Public Const SE_HELFLAG_OPTICAL_PARAMS       As Long = 512
Public Const SE_HELFLAG_NO_DETAILS           As Long = 1024
Public Const SE_HELFLAG_SEARCH_1_PERIOD      As Long = (2048) '  /*  2048 */
Public Const SE_HELFLAG_VISLIM_DARK          As Long = (4096) '  /*  4096 */
Public Const SE_HELFLAG_VISLIM_NOMOON        As Long = (8192) '  /*  8192 */
'/* the following undocumented defines are for test reasons only */
Public Const SE_HELFLAG_VISLIM_PHOTOPIC      As Long = (16384) '  /* 16384 */
Public Const SE_HELFLAG_VISLIM_SCOTOPIC      As Long = (32768) '  /* 32768 */
Public Const SE_HELFLAG_AV                   As Long = (65536) '  /* 65536 */
Public Const SE_HELFLAG_AVKIND_VR            As Long = (65536) '  /* 65536 */
Public Const SE_HELFLAG_AVKIND_PTO           As Long = (131072)
Public Const SE_HELFLAG_AVKIND_MIN7          As Long = (262144)
Public Const SE_HELFLAG_AVKIND_MIN9          As Long = (524288)
Public Const SE_HELFLAG_AVKIND               As Long = (SE_HELFLAG_AVKIND_VR Or SE_HELFLAG_AVKIND_PTO Or SE_HELFLAG_AVKIND_MIN7 Or SE_HELFLAG_AVKIND_MIN9)
Public Const TJD_INVALID                     As Long = 99999999 '#
Public Const SIMULATE_VICTORVB               As Long = 1
'
'#if 0  // unused and redundant
Public Const SE_HELIACAL_LONG_SEARCH         As Long = 128
Public Const SE_HELIACAL_HIGH_PRECISION      As Long = 256
Public Const SE_HELIACAL_OPTICAL_PARAMS      As Long = 512
Public Const SE_HELIACAL_NO_DETAILS          As Long = 1024
Public Const SE_HELIACAL_SEARCH_1_PERIOD     As Long = (2048) '  /*  2048 */
Public Const SE_HELIACAL_VISLIM_DARK         As Long = (4096) '  /*  4096 */
Public Const SE_HELIACAL_VISLIM_NOMOON       As Long = (8192) '  /*  8192 */
Public Const SE_HELIACAL_VISLIM_PHOTOPIC     As Long = (16384) '  /* 16384 */
Public Const SE_HELIACAL_AVKIND_VR           As Long = (32768) '  /* 32768 */
Public Const SE_HELIACAL_AVKIND_PTO          As Long = (65536)
Public Const SE_HELIACAL_AVKIND_MIN7         As Long = (131072)
Public Const SE_HELIACAL_AVKIND_MIN9         As Long = (262144)
Public Const SE_HELIACAL_AVKIND              As Long = (SE_HELFLAG_AVKIND_VR Or SE_HELFLAG_AVKIND_PTO Or SE_HELFLAG_AVKIND_MIN7 Or SE_HELFLAG_AVKIND_MIN9)
'#endif
'
Public Const SE_PHOTOPIC_FLAG                As Long = 0
Public Const SE_SCOTOPIC_FLAG                As Long = 1
Public Const SE_MIXEDOPIC_FLAG               As Long = 2
'
'/* for swe_set_tid_acc() and ephemeris-dependent delta t:
' * intrinsic tidal acceleration in the mean motion of the moon,
' * not given in the parameters list of the ephemeris files but computed
' * by Chapront/Chapront-Touz/Francou A&A 387 (2002), p. 705.
' */
Public Const SE_TIDAL_DE200                  As Double = (-23.8946)
Public Const SE_TIDAL_DE403                  As Double = (-25.58) '  /* was (-25.8) until V. 1.76.2 */
Public Const SE_TIDAL_DE404                  As Double = (-25.58) '  /* was (-25.8) until V. 1.76.2 */
Public Const SE_TIDAL_DE405                  As Double = (-25.826) '  /* was (-25.7376) until V. 1.76.2 */
Public Const SE_TIDAL_DE406                  As Double = (-25.826) '  /* was (-25.7376) until V. 1.76.2 */
Public Const SE_TIDAL_DE421                  As Double = (-25.85) '   /* JPL Interoffice Memorandum 14-mar-2008 on DE421 Lunar Orbit */
Public Const SE_TIDAL_DE422                  As Double = (-25.85) '   /* JPL Interoffice Memorandum 14-mar-2008 on DE421 (sic!) Lunar Orbit */
Public Const SE_TIDAL_DE430                  As Double = (-25.82) '   /* JPL Interoffice Memorandum 9-jul-2013 on DE430 Lunar Orbit */
Public Const SE_TIDAL_DE431                  As Double = (-25.8) '   /* IPN Progress Report 42-196  February 15, 2014, p. 15; was (-25.82) in V. 2.00.00 */
Public Const SE_TIDAL_DE441                  As Double = (-25.936) '   /* unpublished value, from email by Jon Giorgini to DK on 11 Apr 2021 */
Public Const SE_TIDAL_26                     As Double = (-26#)
Public Const SE_TIDAL_STEPHENSON_2016        As Double = (-25.85)
Public Const SE_TIDAL_DEFAULT                As Double = SE_TIDAL_DE431
Public Const SE_TIDAL_AUTOMATIC              As Double = 999999#
Public Const SE_TIDAL_MOSEPH                 As Double = SE_TIDAL_DE404
Public Const SE_TIDAL_SWIEPH                 As Double = SE_TIDAL_DEFAULT
Public Const SE_TIDAL_JPLEPH                 As Double = SE_TIDAL_DEFAULT
'
'/* for function swe_set_delta_t_userdef() */
Public Const SE_DELTAT_AUTOMATIC             As Double = (-0.0000000001)
'
Public Const SE_MODEL_DELTAT                 As Long = 0
Public Const SE_MODEL_PREC_LONGTERM          As Long = 1
Public Const SE_MODEL_PREC_SHORTTERM         As Long = 2
Public Const SE_MODEL_NUT                    As Long = 3
Public Const SE_MODEL_BIAS                   As Long = 4
Public Const SE_MODEL_JPLHOR_MODE            As Long = 5
Public Const SE_MODEL_JPLHORA_MODE           As Long = 6
Public Const SE_MODEL_SIDT                   As Long = 7
Public Const NSE_MODELS                      As Long = 8
'
'/* precession models */
Public Const SEMOD_NPREC                     As Long = 11
Public Const SEMOD_PREC_IAU_1976             As Long = 1
Public Const SEMOD_PREC_LASKAR_1986          As Long = 2
Public Const SEMOD_PREC_WILL_EPS_LASK        As Long = 3
Public Const SEMOD_PREC_WILLIAMS_1994        As Long = 4
Public Const SEMOD_PREC_SIMON_1994           As Long = 5
Public Const SEMOD_PREC_IAU_2000             As Long = 6
Public Const SEMOD_PREC_BRETAGNON_2003       As Long = 7
Public Const SEMOD_PREC_IAU_2006             As Long = 8
Public Const SEMOD_PREC_VONDRAK_2011         As Long = 9
Public Const SEMOD_PREC_OWEN_1990            As Long = 10
Public Const SEMOD_PREC_NEWCOMB              As Long = 11
Public Const SEMOD_PREC_DEFAULT              As Long = SEMOD_PREC_VONDRAK_2011
'/* SE versions before 1.70 used IAU 1976 precession for
' * a limited time range of 2 centuries in combination with
' * the long-term precession Simon 1994.
' */
Public Const SEMOD_PREC_DEFAULT_SHORT        As Long = SEMOD_PREC_VONDRAK_2011
'
'/* nutation models */
Public Const SEMOD_NNUT                      As Long = 5
Public Const SEMOD_NUT_IAU_1980              As Long = 1
Public Const SEMOD_NUT_IAU_CORR_1987         As Long = 2 '/* Herring's (1987) corrections to IAU 1980
'                   * nutation series. AA (1996) neglects them.*/
Public Const SEMOD_NUT_IAU_2000A             As Long = 3 '/* very time consuming ! */
Public Const SEMOD_NUT_IAU_2000B             As Long = 4 '/* fast, but precision of milli-arcsec */
Public Const SEMOD_NUT_WOOLARD               As Long = 5
Public Const SEMOD_NUT_DEFAULT               As Long = SEMOD_NUT_IAU_2000B '/* fast, but precision of milli-arcsec */
'
'/* methods for sidereal time */
Public Const SEMOD_NSIDT                     As Long = 4
Public Const SEMOD_SIDT_IAU_1976             As Long = 1
Public Const SEMOD_SIDT_IAU_2006             As Long = 2
Public Const SEMOD_SIDT_IERS_CONV_2010       As Long = 3
Public Const SEMOD_SIDT_LONGTERM             As Long = 4
Public Const SEMOD_SIDT_DEFAULT              As Long = SEMOD_SIDT_LONGTERM
'//#define SEMOD_SIDT_DEFAULT          SEMOD_SIDT_IERS_CONV_2010
'
'/* frame bias methods */
Public Const SEMOD_NBIAS                     As Long = 3
Public Const SEMOD_BIAS_NONE                 As Long = 1 '/* ignore frame bias */
Public Const SEMOD_BIAS_IAU2000              As Long = 2 '/* use frame bias matrix IAU 2000 */
Public Const SEMOD_BIAS_IAU2006              As Long = 3 '/* use frame bias matrix IAU 2006 */
Public Const SEMOD_BIAS_DEFAULT              As Long = SEMOD_BIAS_IAU2006
'
'/* methods of JPL Horizons (iflag & SEFLG_JPLHOR),
' * using daily dpsi, deps;  see explanations below */
Public Const SEMOD_NJPLHOR                   As Long = 2
Public Const SEMOD_JPLHOR_LONG_AGREEMENT     As Long = 1 '/* daily dpsi and deps from file are
'                                     * limited to 1962 - today. JPL uses the
'                    * first and last value for all  dates
'                    * beyond this time range. */
Public Const SEMOD_JPLHOR_DEFAULT            As Long = SEMOD_JPLHOR_LONG_AGREEMENT
'/* Note, currently this is the only option for SEMOD_JPLHOR..*/
'/* SEMOD_JPLHOR_LONG_AGREEMENT, if combined with SEFLG_JPLHOR provides good
' * agreement with JPL Horizons for 9998 BC (-9997) until 9999 CE.
' * - After 20-jan-1962 until today, Horizons uses correct dpsi and deps.
' * - For dates before that, it uses dpsi and deps of 20-jan-1962, which
' *   provides a continuous ephemeris, but does not make sense otherwise.
' * - Before 1.1.1799 and after 1.1.2202, the precession model Owen 1990
' *   is used, as in Horizons.
' * An agreement with Horizons to a couple of milli arc seconds is achieved
' * for the whole time range of Horizons. (BC 9998-Mar-20 to AD 9999-Dec-31 TT.)
' */
'
'/* methods of approximation of JPL Horizons (iflag & SEFLG_JPLHORA),
' * without dpsi, deps; see explanations below */
Public Const SEMOD_NJPLHORA                  As Long = 3
Public Const SEMOD_JPLHORA_1                 As Long = 1
Public Const SEMOD_JPLHORA_2                 As Long = 2
Public Const SEMOD_JPLHORA_3                 As Long = 3
Public Const SEMOD_JPLHORA_DEFAULT           As Long = SEMOD_JPLHORA_3
'/* With SEMOD_JPLHORA_1, planetary positions are always calculated
' * using a recent precession/nutation model. Frame bias matrix is applied
' * with some correction to RA and another correction added to epsilon.
' * This provides a very good approximation of JPL Horizons positions.
' *
' * With SEMOD_JPLHORA_2, frame bias as recommended by IERS Conventions 2003
' * and 2010 is *not* applied. Instead, dpsi_bias and deps_bias are added to
' * nutation. This procedure is found in some older astronomical software.
' * Equatorial apparent positions will be close to JPL Horizons
' * (within a few mas) between 1962 and current years. Ecl. longitude
' * will be good, latitude bad.
' *
' * With SEMOD_JPLHORA_3 works like SEMOD_JPLHORA_3 after 1962, but like
' * SEFLG_JPLHOR before that. This allows EXTREMELY good agreement with JPL
' * Horizons over its whole time range.
' */
'
Public Const SEMOD_NDELTAT                   As Long = 5
Public Const SEMOD_DELTAT_STEPHENSON_MORRISON_1984 As Long = 1
Public Const SEMOD_DELTAT_STEPHENSON_1997    As Long = 2
Public Const SEMOD_DELTAT_STEPHENSON_MORRISON_2004 As Long = 3
Public Const SEMOD_DELTAT_ESPENAK_MEEUS_2006 As Long = 4
Public Const SEMOD_DELTAT_STEPHENSON_ETC_2016 As Long = 5
'//#define SEMOD_DELTAT_DEFAULT   SEMOD_DELTAT_ESPENAK_MEEUS_2006
Public Const SEMOD_DELTAT_DEFAULT            As Long = SEMOD_DELTAT_STEPHENSON_ETC_2016
'
'
'--------------------------------------------------------------------------------
'{H1}Total Exports Constants: 338
'================================================================================
'Total Exports constants: 338
'################################################################################
'End of Exports Constants from Header File:*.H
'Export Constants are taken from swephexp.h header file only and
'other header files are not considered to Export Constants.
'Users may refer other header files to Export Constants(if required) or
'create their own Constants of their needs matching required Data type.
'################################################################################
'===================End of Constants Declerations===============================

'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
'=============Additional API Declarations/User Defined functions================
'API Declarations to convert PointerToChars to VBString
Private Declare Function lstrlenA Lib "kernel32.dll" (ByVal lpString As Long) As Long
Private Declare Function SysAllocStringByteLen Lib "oleaut32.dll" (Optional ByVal pszStrPtr As Long, Optional ByVal length As Long) As String

'User defined function to convert PointerToChars(LPCHARA) to VBString
Public Function GetStrFromLPCHARA(ByVal lpCHARA As Long) As String
    GetStrFromLPCHARA = SysAllocStringByteLen(lpCHARA, lstrlenA(lpCHARA))
End Function

'User defined function to trim NullChar in the Text/String
Public Function TrimNullChar(ByVal sText As String) As String
Dim lPos As Long
lPos = InStr(sText, vbNullChar) 'Chr$(0))
If (lPos > 0) Then sText = Left(sText, lPos - 1)
TrimNullChar = sText
End Function
'=========End of additional API Declarations/User Defined functions=============
'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

