Attribute VB_Name = "modTestSwedll32"
'=======================================================================
' Test module for Swiss Ephemeris Visual Basic 32-bit API functions
' DLLFileName       :swedll32.dll
' DLLFileSize       :942,592 bytes
' DLLFileDateTime   :04/08/2021  14:04:22
' DLLFileType       :Dynamic link Library(32Bits)
' DLLFileVersion    :2.10.02
' --------------------------------------------------------------
' ThisFileName      :modTestSwedll32.bas
' Created on        :14.10.2021
' Created by        :D.Senthilathiban (Email:athi_ram@yahoo.com)
'===============================================================
'
' from posting by D.Senthilathiban (Email:athi_ram@yahoo.com) in
' Swiss Ephemeris mailing list
'
' This file is in the Public Domain last updated on 14-Oct-2021
'
' The swedll32.dll file must exist in the same directory as the VB executable,
' or in a system directory where it can be found at runtime
'
' *********************CAUTION/WARNING:*************************************
' Test subroutines are written without any arguments and the required argument
' values for the respective Swiss Ephemeris Visual Basic 32-bit API functions
' are selected randomly as a default in respective subroutines for the purpose
' of testing only. However, the user may do changes as required.
'
' For more/updated details of functions/variables and Return values/Errors
' refer webpage https://www.astro.com/swisseph/swephprg.htm
' Programming interface to the Swiss Ephemeris Manual.
''**************************************************************************
'
'/*
'
'  License conditions
'  ------------------
'
'  This file is distributed with NO WARRANTY OF ANY KIND. No author/contributor
'  or distributor accepts any responsibility for the consequences of using it,
'  or for whether it serves any particular purpose or works at all.
'
'  The License grants you the right to use, copy, modify and redistribute,
'  but only under certain conditions that the File information, author/contributor
'  details and this notice be preserved on all copies.
'
'  The author/contributor have no control or influence over any of
'  the derived works, i.e. over software or services created by other
'  programmers which use Swiss Ephemeris functions.
'
'
'*/
Option Explicit

Sub TestSwedll32()
Dim i As Long, lStart As Long, lStop As Long
Dim sMethodName As String
Dim cSweTest As clsTestSwedll32
Set cSweTest = New clsTestSwedll32
'##########change the
'default path for Ephemeris Files & it can be changed as required
cSweTest.SwissFilePath = ActiveWorkbook.path + SE_EPHE_PATH
'default path/filename for Test output File & it can be changed as required
cSweTest.TestFilePath = ActiveWorkbook.path + "\TestSwedll32.txt"
'Use 0 for debug mode output & 1 for output to File
cSweTest.FileOUT = 1 'default output to File

' *********************CAUTION/WARNING:*************************************
' It is noticed that sometime the VBA Crash before completing all the tests
' given in the below for loop. Hence the Test output File is opened in Append
' mode to write the results up to the successful call of Test function.Hence
' incase of any crash, the next test can start from remaining Test function
' by adjusting lStart Number. Alternatively call cSweTest object methods/
' functions directly to test the specific Test.
'***************************************************************************
lStart = 1: lStop = 106
For i = lStart To lStop
    sMethodName = "Test" + Trim$(Str$(i))
    'i=6 is for Test6 to close resources used by Swedll32.dll and
    'it must be called after completing all tests at the last
    If i <> 6 Then Call CallByName(cSweTest, sMethodName, VbMethod)
    Debug.Print i
Next i
'Test6 is to close resources used by Swedll32.dll and
'it must be called after completing all tests at the last
sMethodName = "Test6"
Call CallByName(cSweTest, sMethodName, VbMethod)
Debug.Print 6
Set cSweTest = Nothing
Debug.Print "Test Finished"

End Sub
